/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.fluent.models;

import com.azure.resourcemanager.storage.fluent.models.BlobRestoreStatusInner;
import com.azure.resourcemanager.storage.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.storage.models.AccessTier;
import com.azure.resourcemanager.storage.models.AccountStatus;
import com.azure.resourcemanager.storage.models.AllowedCopyScope;
import com.azure.resourcemanager.storage.models.AzureFilesIdentityBasedAuthentication;
import com.azure.resourcemanager.storage.models.CustomDomain;
import com.azure.resourcemanager.storage.models.DnsEndpointType;
import com.azure.resourcemanager.storage.models.Encryption;
import com.azure.resourcemanager.storage.models.Endpoints;
import com.azure.resourcemanager.storage.models.GeoReplicationStats;
import com.azure.resourcemanager.storage.models.ImmutableStorageAccount;
import com.azure.resourcemanager.storage.models.KeyCreationTime;
import com.azure.resourcemanager.storage.models.KeyPolicy;
import com.azure.resourcemanager.storage.models.LargeFileSharesState;
import com.azure.resourcemanager.storage.models.MinimumTlsVersion;
import com.azure.resourcemanager.storage.models.NetworkRuleSet;
import com.azure.resourcemanager.storage.models.ProvisioningState;
import com.azure.resourcemanager.storage.models.PublicNetworkAccess;
import com.azure.resourcemanager.storage.models.RoutingPreference;
import com.azure.resourcemanager.storage.models.SasPolicy;
import com.azure.resourcemanager.storage.models.StorageAccountSkuConversionStatus;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

public final class StorageAccountPropertiesInner {
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="primaryEndpoints", access=JsonProperty.Access.WRITE_ONLY)
    private Endpoints primaryEndpoints;
    @JsonProperty(value="primaryLocation", access=JsonProperty.Access.WRITE_ONLY)
    private String primaryLocation;
    @JsonProperty(value="statusOfPrimary", access=JsonProperty.Access.WRITE_ONLY)
    private AccountStatus statusOfPrimary;
    @JsonProperty(value="lastGeoFailoverTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime lastGeoFailoverTime;
    @JsonProperty(value="secondaryLocation", access=JsonProperty.Access.WRITE_ONLY)
    private String secondaryLocation;
    @JsonProperty(value="statusOfSecondary", access=JsonProperty.Access.WRITE_ONLY)
    private AccountStatus statusOfSecondary;
    @JsonProperty(value="creationTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime creationTime;
    @JsonProperty(value="customDomain", access=JsonProperty.Access.WRITE_ONLY)
    private CustomDomain customDomain;
    @JsonProperty(value="sasPolicy", access=JsonProperty.Access.WRITE_ONLY)
    private SasPolicy sasPolicy;
    @JsonProperty(value="keyPolicy", access=JsonProperty.Access.WRITE_ONLY)
    private KeyPolicy keyPolicy;
    @JsonProperty(value="keyCreationTime", access=JsonProperty.Access.WRITE_ONLY)
    private KeyCreationTime keyCreationTime;
    @JsonProperty(value="secondaryEndpoints", access=JsonProperty.Access.WRITE_ONLY)
    private Endpoints secondaryEndpoints;
    @JsonProperty(value="encryption", access=JsonProperty.Access.WRITE_ONLY)
    private Encryption encryption;
    @JsonProperty(value="accessTier", access=JsonProperty.Access.WRITE_ONLY)
    private AccessTier accessTier;
    @JsonProperty(value="azureFilesIdentityBasedAuthentication")
    private AzureFilesIdentityBasedAuthentication azureFilesIdentityBasedAuthentication;
    @JsonProperty(value="supportsHttpsTrafficOnly")
    private Boolean enableHttpsTrafficOnly;
    @JsonProperty(value="networkAcls", access=JsonProperty.Access.WRITE_ONLY)
    private NetworkRuleSet networkRuleSet;
    @JsonProperty(value="isSftpEnabled")
    private Boolean isSftpEnabled;
    @JsonProperty(value="isLocalUserEnabled")
    private Boolean isLocalUserEnabled;
    @JsonProperty(value="isHnsEnabled")
    private Boolean isHnsEnabled;
    @JsonProperty(value="geoReplicationStats", access=JsonProperty.Access.WRITE_ONLY)
    private GeoReplicationStats geoReplicationStats;
    @JsonProperty(value="failoverInProgress", access=JsonProperty.Access.WRITE_ONLY)
    private Boolean failoverInProgress;
    @JsonProperty(value="largeFileSharesState")
    private LargeFileSharesState largeFileSharesState;
    @JsonProperty(value="privateEndpointConnections", access=JsonProperty.Access.WRITE_ONLY)
    private List<PrivateEndpointConnectionInner> privateEndpointConnections;
    @JsonProperty(value="routingPreference")
    private RoutingPreference routingPreference;
    @JsonProperty(value="blobRestoreStatus", access=JsonProperty.Access.WRITE_ONLY)
    private BlobRestoreStatusInner blobRestoreStatus;
    @JsonProperty(value="allowBlobPublicAccess")
    private Boolean allowBlobPublicAccess;
    @JsonProperty(value="minimumTlsVersion")
    private MinimumTlsVersion minimumTlsVersion;
    @JsonProperty(value="allowSharedKeyAccess")
    private Boolean allowSharedKeyAccess;
    @JsonProperty(value="isNfsV3Enabled")
    private Boolean enableNfsV3;
    @JsonProperty(value="allowCrossTenantReplication")
    private Boolean allowCrossTenantReplication;
    @JsonProperty(value="defaultToOAuthAuthentication")
    private Boolean defaultToOAuthAuthentication;
    @JsonProperty(value="publicNetworkAccess")
    private PublicNetworkAccess publicNetworkAccess;
    @JsonProperty(value="immutableStorageWithVersioning")
    private ImmutableStorageAccount immutableStorageWithVersioning;
    @JsonProperty(value="allowedCopyScope")
    private AllowedCopyScope allowedCopyScope;
    @JsonProperty(value="storageAccountSkuConversionStatus")
    private StorageAccountSkuConversionStatus storageAccountSkuConversionStatus;
    @JsonProperty(value="dnsEndpointType")
    private DnsEndpointType dnsEndpointType;
    @JsonProperty(value="isSkuConversionBlocked", access=JsonProperty.Access.WRITE_ONLY)
    private Boolean isSkuConversionBlocked;
    @JsonProperty(value="accountMigrationInProgress", access=JsonProperty.Access.WRITE_ONLY)
    private Boolean accountMigrationInProgress;

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public Endpoints primaryEndpoints() {
        return this.primaryEndpoints;
    }

    public String primaryLocation() {
        return this.primaryLocation;
    }

    public AccountStatus statusOfPrimary() {
        return this.statusOfPrimary;
    }

    public OffsetDateTime lastGeoFailoverTime() {
        return this.lastGeoFailoverTime;
    }

    public String secondaryLocation() {
        return this.secondaryLocation;
    }

    public AccountStatus statusOfSecondary() {
        return this.statusOfSecondary;
    }

    public OffsetDateTime creationTime() {
        return this.creationTime;
    }

    public CustomDomain customDomain() {
        return this.customDomain;
    }

    public SasPolicy sasPolicy() {
        return this.sasPolicy;
    }

    public KeyPolicy keyPolicy() {
        return this.keyPolicy;
    }

    public KeyCreationTime keyCreationTime() {
        return this.keyCreationTime;
    }

    public Endpoints secondaryEndpoints() {
        return this.secondaryEndpoints;
    }

    public Encryption encryption() {
        return this.encryption;
    }

    public AccessTier accessTier() {
        return this.accessTier;
    }

    public AzureFilesIdentityBasedAuthentication azureFilesIdentityBasedAuthentication() {
        return this.azureFilesIdentityBasedAuthentication;
    }

    public StorageAccountPropertiesInner withAzureFilesIdentityBasedAuthentication(AzureFilesIdentityBasedAuthentication azureFilesIdentityBasedAuthentication) {
        this.azureFilesIdentityBasedAuthentication = azureFilesIdentityBasedAuthentication;
        return this;
    }

    public Boolean enableHttpsTrafficOnly() {
        return this.enableHttpsTrafficOnly;
    }

    public StorageAccountPropertiesInner withEnableHttpsTrafficOnly(Boolean enableHttpsTrafficOnly) {
        this.enableHttpsTrafficOnly = enableHttpsTrafficOnly;
        return this;
    }

    public NetworkRuleSet networkRuleSet() {
        return this.networkRuleSet;
    }

    public Boolean isSftpEnabled() {
        return this.isSftpEnabled;
    }

    public StorageAccountPropertiesInner withIsSftpEnabled(Boolean isSftpEnabled) {
        this.isSftpEnabled = isSftpEnabled;
        return this;
    }

    public Boolean isLocalUserEnabled() {
        return this.isLocalUserEnabled;
    }

    public StorageAccountPropertiesInner withIsLocalUserEnabled(Boolean isLocalUserEnabled) {
        this.isLocalUserEnabled = isLocalUserEnabled;
        return this;
    }

    public Boolean isHnsEnabled() {
        return this.isHnsEnabled;
    }

    public StorageAccountPropertiesInner withIsHnsEnabled(Boolean isHnsEnabled) {
        this.isHnsEnabled = isHnsEnabled;
        return this;
    }

    public GeoReplicationStats geoReplicationStats() {
        return this.geoReplicationStats;
    }

    public Boolean failoverInProgress() {
        return this.failoverInProgress;
    }

    public LargeFileSharesState largeFileSharesState() {
        return this.largeFileSharesState;
    }

    public StorageAccountPropertiesInner withLargeFileSharesState(LargeFileSharesState largeFileSharesState) {
        this.largeFileSharesState = largeFileSharesState;
        return this;
    }

    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    public RoutingPreference routingPreference() {
        return this.routingPreference;
    }

    public StorageAccountPropertiesInner withRoutingPreference(RoutingPreference routingPreference) {
        this.routingPreference = routingPreference;
        return this;
    }

    public BlobRestoreStatusInner blobRestoreStatus() {
        return this.blobRestoreStatus;
    }

    public Boolean allowBlobPublicAccess() {
        return this.allowBlobPublicAccess;
    }

    public StorageAccountPropertiesInner withAllowBlobPublicAccess(Boolean allowBlobPublicAccess) {
        this.allowBlobPublicAccess = allowBlobPublicAccess;
        return this;
    }

    public MinimumTlsVersion minimumTlsVersion() {
        return this.minimumTlsVersion;
    }

    public StorageAccountPropertiesInner withMinimumTlsVersion(MinimumTlsVersion minimumTlsVersion) {
        this.minimumTlsVersion = minimumTlsVersion;
        return this;
    }

    public Boolean allowSharedKeyAccess() {
        return this.allowSharedKeyAccess;
    }

    public StorageAccountPropertiesInner withAllowSharedKeyAccess(Boolean allowSharedKeyAccess) {
        this.allowSharedKeyAccess = allowSharedKeyAccess;
        return this;
    }

    public Boolean enableNfsV3() {
        return this.enableNfsV3;
    }

    public StorageAccountPropertiesInner withEnableNfsV3(Boolean enableNfsV3) {
        this.enableNfsV3 = enableNfsV3;
        return this;
    }

    public Boolean allowCrossTenantReplication() {
        return this.allowCrossTenantReplication;
    }

    public StorageAccountPropertiesInner withAllowCrossTenantReplication(Boolean allowCrossTenantReplication) {
        this.allowCrossTenantReplication = allowCrossTenantReplication;
        return this;
    }

    public Boolean defaultToOAuthAuthentication() {
        return this.defaultToOAuthAuthentication;
    }

    public StorageAccountPropertiesInner withDefaultToOAuthAuthentication(Boolean defaultToOAuthAuthentication) {
        this.defaultToOAuthAuthentication = defaultToOAuthAuthentication;
        return this;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public StorageAccountPropertiesInner withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public ImmutableStorageAccount immutableStorageWithVersioning() {
        return this.immutableStorageWithVersioning;
    }

    public StorageAccountPropertiesInner withImmutableStorageWithVersioning(ImmutableStorageAccount immutableStorageWithVersioning) {
        this.immutableStorageWithVersioning = immutableStorageWithVersioning;
        return this;
    }

    public AllowedCopyScope allowedCopyScope() {
        return this.allowedCopyScope;
    }

    public StorageAccountPropertiesInner withAllowedCopyScope(AllowedCopyScope allowedCopyScope) {
        this.allowedCopyScope = allowedCopyScope;
        return this;
    }

    public StorageAccountSkuConversionStatus storageAccountSkuConversionStatus() {
        return this.storageAccountSkuConversionStatus;
    }

    public StorageAccountPropertiesInner withStorageAccountSkuConversionStatus(StorageAccountSkuConversionStatus storageAccountSkuConversionStatus) {
        this.storageAccountSkuConversionStatus = storageAccountSkuConversionStatus;
        return this;
    }

    public DnsEndpointType dnsEndpointType() {
        return this.dnsEndpointType;
    }

    public StorageAccountPropertiesInner withDnsEndpointType(DnsEndpointType dnsEndpointType) {
        this.dnsEndpointType = dnsEndpointType;
        return this;
    }

    public Boolean isSkuConversionBlocked() {
        return this.isSkuConversionBlocked;
    }

    public Boolean accountMigrationInProgress() {
        return this.accountMigrationInProgress;
    }

    public void validate() {
        if (this.primaryEndpoints() != null) {
            this.primaryEndpoints().validate();
        }
        if (this.customDomain() != null) {
            this.customDomain().validate();
        }
        if (this.sasPolicy() != null) {
            this.sasPolicy().validate();
        }
        if (this.keyPolicy() != null) {
            this.keyPolicy().validate();
        }
        if (this.keyCreationTime() != null) {
            this.keyCreationTime().validate();
        }
        if (this.secondaryEndpoints() != null) {
            this.secondaryEndpoints().validate();
        }
        if (this.encryption() != null) {
            this.encryption().validate();
        }
        if (this.azureFilesIdentityBasedAuthentication() != null) {
            this.azureFilesIdentityBasedAuthentication().validate();
        }
        if (this.networkRuleSet() != null) {
            this.networkRuleSet().validate();
        }
        if (this.geoReplicationStats() != null) {
            this.geoReplicationStats().validate();
        }
        if (this.privateEndpointConnections() != null) {
            this.privateEndpointConnections().forEach(e -> e.validate());
        }
        if (this.routingPreference() != null) {
            this.routingPreference().validate();
        }
        if (this.blobRestoreStatus() != null) {
            this.blobRestoreStatus().validate();
        }
        if (this.immutableStorageWithVersioning() != null) {
            this.immutableStorageWithVersioning().validate();
        }
        if (this.storageAccountSkuConversionStatus() != null) {
            this.storageAccountSkuConversionStatus().validate();
        }
    }
}

