/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.storage.models.BlobInventoryPolicyRule;
import com.azure.resourcemanager.storage.models.InventoryRuleType;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class BlobInventoryPolicySchema {
    @JsonProperty(value="enabled", required=true)
    private boolean enabled;
    @JsonProperty(value="destination", access=JsonProperty.Access.WRITE_ONLY)
    private String destination;
    @JsonProperty(value="type", required=true)
    private InventoryRuleType type;
    @JsonProperty(value="rules", required=true)
    private List<BlobInventoryPolicyRule> rules;
    private static final ClientLogger LOGGER = new ClientLogger(BlobInventoryPolicySchema.class);

    public boolean enabled() {
        return this.enabled;
    }

    public BlobInventoryPolicySchema withEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public String destination() {
        return this.destination;
    }

    public InventoryRuleType type() {
        return this.type;
    }

    public BlobInventoryPolicySchema withType(InventoryRuleType type) {
        this.type = type;
        return this;
    }

    public List<BlobInventoryPolicyRule> rules() {
        return this.rules;
    }

    public BlobInventoryPolicySchema withRules(List<BlobInventoryPolicyRule> rules) {
        this.rules = rules;
        return this;
    }

    public void validate() {
        if (this.type() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property type in model BlobInventoryPolicySchema"));
        }
        if (this.rules() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property rules in model BlobInventoryPolicySchema"));
        }
        this.rules().forEach(e -> e.validate());
    }
}

