/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.models;

import com.azure.resourcemanager.msi.models.Identity;
import com.azure.resourcemanager.resources.fluentcore.arm.models.GroupableResource;
import com.azure.resourcemanager.resources.fluentcore.arm.models.Resource;
import com.azure.resourcemanager.resources.fluentcore.collection.SupportsListingPrivateEndpointConnection;
import com.azure.resourcemanager.resources.fluentcore.collection.SupportsListingPrivateLinkResource;
import com.azure.resourcemanager.resources.fluentcore.collection.SupportsUpdatingPrivateEndpointConnection;
import com.azure.resourcemanager.resources.fluentcore.model.Appliable;
import com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.azure.resourcemanager.resources.fluentcore.model.Refreshable;
import com.azure.resourcemanager.resources.fluentcore.model.Updatable;
import com.azure.resourcemanager.storage.StorageManager;
import com.azure.resourcemanager.storage.fluent.models.StorageAccountInner;
import com.azure.resourcemanager.storage.models.AccessTier;
import com.azure.resourcemanager.storage.models.AccountStatuses;
import com.azure.resourcemanager.storage.models.CustomDomain;
import com.azure.resourcemanager.storage.models.IdentityType;
import com.azure.resourcemanager.storage.models.Kind;
import com.azure.resourcemanager.storage.models.MinimumTlsVersion;
import com.azure.resourcemanager.storage.models.ProvisioningState;
import com.azure.resourcemanager.storage.models.PublicEndpoints;
import com.azure.resourcemanager.storage.models.PublicNetworkAccess;
import com.azure.resourcemanager.storage.models.StorageAccountEncryptionKeySource;
import com.azure.resourcemanager.storage.models.StorageAccountEncryptionStatus;
import com.azure.resourcemanager.storage.models.StorageAccountKey;
import com.azure.resourcemanager.storage.models.StorageAccountSkuType;
import com.azure.resourcemanager.storage.models.StorageService;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.Set;
import reactor.core.publisher.Mono;

public interface StorageAccount
extends GroupableResource<StorageManager, StorageAccountInner>,
Refreshable<StorageAccount>,
Updatable<Update>,
SupportsListingPrivateLinkResource,
SupportsListingPrivateEndpointConnection,
SupportsUpdatingPrivateEndpointConnection {
    public AccountStatuses accountStatuses();

    public StorageAccountSkuType skuType();

    public Kind kind();

    public OffsetDateTime creationTime();

    public CustomDomain customDomain();

    public OffsetDateTime lastGeoFailoverTime();

    public ProvisioningState provisioningState();

    public PublicEndpoints endPoints();

    public StorageAccountEncryptionKeySource encryptionKeySource();

    public Map<StorageService, StorageAccountEncryptionStatus> encryptionStatuses();

    public boolean infrastructureEncryptionEnabled();

    public AccessTier accessTier();

    public String systemAssignedManagedServiceIdentityTenantId();

    public String systemAssignedManagedServiceIdentityPrincipalId();

    public Set<String> userAssignedManagedServiceIdentityIds();

    public boolean isAccessAllowedFromAllNetworks();

    public List<String> networkSubnetsWithAccess();

    public List<String> ipAddressesWithAccess();

    public List<String> ipAddressRangesWithAccess();

    public boolean canReadLogEntriesFromAnyNetwork();

    public boolean canReadMetricsFromAnyNetwork();

    public boolean canAccessFromAzureServices();

    public boolean isAzureFilesAadIntegrationEnabled();

    public boolean isHnsEnabled();

    public boolean isLargeFileSharesEnabled();

    public MinimumTlsVersion minimumTlsVersion();

    public boolean isHttpsTrafficOnly();

    public boolean isBlobPublicAccessAllowed();

    public boolean isSharedKeyAccessAllowed();

    public List<StorageAccountKey> getKeys();

    public Mono<List<StorageAccountKey>> getKeysAsync();

    public List<StorageAccountKey> regenerateKey(String var1);

    public Mono<List<StorageAccountKey>> regenerateKeyAsync(String var1);

    public boolean isAllowCrossTenantReplication();

    public boolean isDefaultToOAuthAuthentication();

    public IdentityType identityTypeForCustomerEncryptionKey();

    public String userAssignedIdentityIdForCustomerEncryptionKey();

    public PublicNetworkAccess publicNetworkAccess();

    public static interface Update
    extends Appliable<StorageAccount>,
    UpdateStages.WithSku,
    UpdateStages.WithCustomDomain,
    UpdateStages.WithEncryption,
    UpdateStages.WithAccessTier,
    UpdateStages.WithManagedServiceIdentity,
    UpdateStages.WithUserAssignedManagedServiceIdentity,
    UpdateStages.WithAccessTraffic,
    UpdateStages.WithNetworkAccess,
    UpdateStages.WithUpgrade,
    UpdateStages.WithBlobAccess,
    UpdateStages.WithAllowCrossTenantReplication,
    UpdateStages.WithDefaultToOAuthAuthentication,
    Resource.UpdateWithTags<Update> {
    }

    public static interface UpdateStages {

        public static interface WithDefaultToOAuthAuthentication {
            public Update enableDefaultToOAuthAuthentication();

            public Update disableDefaultToOAuthAuthentication();
        }

        public static interface WithAllowCrossTenantReplication {
            public Update allowCrossTenantReplication();

            public Update disallowCrossTenantReplication();
        }

        public static interface WithUpgrade {
            public Update upgradeToGeneralPurposeAccountKindV2();
        }

        public static interface WithNetworkAccess {
            public Update enablePublicNetworkAccess();

            public Update disablePublicNetworkAccess();

            public Update withAccessFromAllNetworks();

            public Update withAccessFromSelectedNetworks();

            public Update withAccessFromNetworkSubnet(String var1);

            public Update withAccessFromIpAddress(String var1);

            public Update withAccessFromIpAddressRange(String var1);

            public Update withReadAccessToLogEntriesFromAnyNetwork();

            public Update withReadAccessToMetricsFromAnyNetwork();

            public Update withAccessFromAzureServices();

            public Update withoutNetworkSubnetAccess(String var1);

            public Update withoutIpAddressAccess(String var1);

            public Update withoutIpAddressRangeAccess(String var1);

            public Update withoutReadAccessToLoggingFromAnyNetwork();

            public Update withoutReadAccessToMetricsFromAnyNetwork();

            public Update withoutAccessFromAzureServices();

            public Update withAzureFilesAadIntegrationEnabled(boolean var1);
        }

        public static interface WithBlobAccess {
            public Update enableBlobPublicAccess();

            public Update disableBlobPublicAccess();

            public Update enableSharedKeyAccess();

            public Update disableSharedKeyAccess();
        }

        public static interface WithAccessTraffic {
            public Update withOnlyHttpsTraffic();

            public Update withHttpAndHttpsTraffic();

            public Update withMinimumTlsVersion(MinimumTlsVersion var1);
        }

        public static interface WithUserAssignedManagedServiceIdentity {
            public Update withNewUserAssignedManagedServiceIdentity(Creatable<Identity> var1);

            public Update withExistingUserAssignedManagedServiceIdentity(Identity var1);

            public Update withExistingUserAssignedManagedServiceIdentity(String var1);

            public Update withoutUserAssignedManagedServiceIdentity(String var1);
        }

        public static interface WithManagedServiceIdentity {
            public Update withSystemAssignedManagedServiceIdentity();

            public Update withoutSystemAssignedManagedServiceIdentity();
        }

        public static interface WithAccessTier {
            public Update withAccessTier(AccessTier var1);
        }

        public static interface WithEncryption {
            @Deprecated
            public Update withBlobEncryption();

            @Deprecated
            public Update withFileEncryption();

            @Deprecated
            public Update withoutBlobEncryption();

            @Deprecated
            public Update withoutFileEncryption();

            public Update withEncryptionKeyFromKeyVault(String var1, String var2, String var3);

            public Update withEncryptionKeyFromKeyVault(String var1, String var2, String var3, Identity var4);

            public Update withEncryptionKeyFromKeyVault(String var1, String var2, String var3, String var4);

            public Update withMicrosoftManagedEncryptionKey();
        }

        public static interface WithCustomDomain {
            public Update withCustomDomain(CustomDomain var1);

            public Update withCustomDomain(String var1);

            public Update withCustomDomain(String var1, boolean var2);
        }

        public static interface WithSku {
            public Update withSku(StorageAccountSkuType var1);
        }
    }

    public static interface DefinitionStages {

        public static interface WithCreateAndAccessTier
        extends WithCreate {
            public WithCreate withAccessTier(AccessTier var1);
        }

        public static interface WithCreate
        extends Creatable<StorageAccount>,
        WithSku,
        WithBlobStorageAccountKind,
        WithGeneralPurposeAccountKind,
        WithBlockBlobStorageAccountKind,
        WithFileStorageAccountKind,
        WithEncryption,
        WithCustomDomain,
        WithManagedServiceIdentity,
        WithUserAssignedManagedServiceIdentity,
        WithAccessTraffic,
        WithNetworkAccess,
        WithAzureFilesAadIntegration,
        WithLargeFileShares,
        WithHns,
        WithBlobAccess,
        WithAllowCrossTenantReplication,
        WithDefaultToOAuthAuthentication,
        Resource.DefinitionWithTags<WithCreate> {
        }

        public static interface WithDefaultToOAuthAuthentication {
            public WithCreate enableDefaultToOAuthAuthentication();
        }

        public static interface WithAllowCrossTenantReplication {
            public WithCreate disallowCrossTenantReplication();
        }

        public static interface WithHns {
            public WithCreate withHnsEnabled(boolean var1);
        }

        public static interface WithLargeFileShares {
            public WithCreate withLargeFileShares(boolean var1);
        }

        public static interface WithAzureFilesAadIntegration {
            public WithCreate withAzureFilesAadIntegrationEnabled(boolean var1);
        }

        public static interface WithNetworkAccess {
            public WithCreate disablePublicNetworkAccess();

            public WithCreate withAccessFromAllNetworks();

            public WithCreate withAccessFromSelectedNetworks();

            public WithCreate withAccessFromNetworkSubnet(String var1);

            public WithCreate withAccessFromIpAddress(String var1);

            public WithCreate withAccessFromIpAddressRange(String var1);

            public WithCreate withReadAccessToLogEntriesFromAnyNetwork();

            public WithCreate withReadAccessToMetricsFromAnyNetwork();

            public WithCreate withAccessFromAzureServices();
        }

        public static interface WithBlobAccess {
            public WithCreate disableBlobPublicAccess();

            public WithCreate disableSharedKeyAccess();
        }

        public static interface WithAccessTraffic {
            public WithCreate withOnlyHttpsTraffic();

            public WithCreate withHttpAndHttpsTraffic();

            public WithCreate withMinimumTlsVersion(MinimumTlsVersion var1);
        }

        public static interface WithUserAssignedManagedServiceIdentity {
            public WithCreate withNewUserAssignedManagedServiceIdentity(Creatable<Identity> var1);

            public WithCreate withExistingUserAssignedManagedServiceIdentity(Identity var1);

            public WithCreate withExistingUserAssignedManagedServiceIdentity(String var1);
        }

        public static interface WithManagedServiceIdentity {
            public WithCreate withSystemAssignedManagedServiceIdentity();
        }

        public static interface WithCustomDomain {
            public WithCreate withCustomDomain(CustomDomain var1);

            public WithCreate withCustomDomain(String var1);

            public WithCreate withCustomDomain(String var1, boolean var2);
        }

        public static interface WithEncryption {
            public WithCreate withInfrastructureEncryption();

            @Deprecated
            public WithCreate withBlobEncryption();

            @Deprecated
            public WithCreate withoutBlobEncryption();

            @Deprecated
            public WithCreate withFileEncryption();

            @Deprecated
            public WithCreate withoutFileEncryption();

            public WithCreate withTableAccountScopedEncryptionKey();

            public WithCreate withQueueAccountScopedEncryptionKey();

            public WithCreate withEncryptionKeyFromKeyVault(String var1, String var2, String var3);

            public WithCreate withEncryptionKeyFromKeyVault(String var1, String var2, String var3, Identity var4);

            public WithCreate withEncryptionKeyFromKeyVault(String var1, String var2, String var3, String var4);
        }

        public static interface WithFileStorageAccountKind {
            public WithCreate withFileStorageAccountKind();
        }

        public static interface WithBlockBlobStorageAccountKind {
            public WithCreate withBlockBlobStorageAccountKind();
        }

        public static interface WithGeneralPurposeAccountKind {
            public WithCreate withGeneralPurposeAccountKind();

            public WithCreate withGeneralPurposeAccountKindV2();
        }

        public static interface WithBlobStorageAccountKind {
            public WithCreateAndAccessTier withBlobStorageAccountKind();
        }

        public static interface WithSku {
            public WithCreate withSku(StorageAccountSkuType var1);
        }

        public static interface WithGroup
        extends GroupableResource.DefinitionStages.WithGroup<WithCreate> {
        }

        public static interface Blank
        extends Resource.DefinitionWithRegion<WithGroup> {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithGroup,
    DefinitionStages.WithCreate,
    DefinitionStages.WithCreateAndAccessTier {
    }
}

