// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** An object that wraps the blob inventory rule. Each rule is uniquely defined by name. */
@Fluent
public final class BlobInventoryPolicyRule {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(BlobInventoryPolicyRule.class);

    /*
     * Rule is enabled when set to true.
     */
    @JsonProperty(value = "enabled", required = true)
    private boolean enabled;

    /*
     * A rule name can contain any combination of alpha numeric characters.
     * Rule name is case-sensitive. It must be unique within a policy.
     */
    @JsonProperty(value = "name", required = true)
    private String name;

    /*
     * An object that defines the blob inventory policy rule.
     */
    @JsonProperty(value = "definition", required = true)
    private BlobInventoryPolicyDefinition definition;

    /**
     * Get the enabled property: Rule is enabled when set to true.
     *
     * @return the enabled value.
     */
    public boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: Rule is enabled when set to true.
     *
     * @param enabled the enabled value to set.
     * @return the BlobInventoryPolicyRule object itself.
     */
    public BlobInventoryPolicyRule withEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Get the name property: A rule name can contain any combination of alpha numeric characters. Rule name is
     * case-sensitive. It must be unique within a policy.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: A rule name can contain any combination of alpha numeric characters. Rule name is
     * case-sensitive. It must be unique within a policy.
     *
     * @param name the name value to set.
     * @return the BlobInventoryPolicyRule object itself.
     */
    public BlobInventoryPolicyRule withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the definition property: An object that defines the blob inventory policy rule.
     *
     * @return the definition value.
     */
    public BlobInventoryPolicyDefinition definition() {
        return this.definition;
    }

    /**
     * Set the definition property: An object that defines the blob inventory policy rule.
     *
     * @param definition the definition value to set.
     * @return the BlobInventoryPolicyRule object itself.
     */
    public BlobInventoryPolicyRule withDefinition(BlobInventoryPolicyDefinition definition) {
        this.definition = definition;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() == null) {
            throw logger
                .logExceptionAsError(
                    new IllegalArgumentException("Missing required property name in model BlobInventoryPolicyRule"));
        }
        if (definition() == null) {
            throw logger
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property definition in model BlobInventoryPolicyRule"));
        } else {
            definition().validate();
        }
    }
}
