// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Object to define the number of days after object last modification Or last access. Properties
 * daysAfterModificationGreaterThan and daysAfterLastAccessTimeGreaterThan are mutually exclusive.
 */
@Fluent
public final class DateAfterModification {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(DateAfterModification.class);

    /*
     * Value indicating the age in days after last modification
     */
    @JsonProperty(value = "daysAfterModificationGreaterThan")
    private Float daysAfterModificationGreaterThan;

    /*
     * Value indicating the age in days after last blob access. This property
     * can only be used in conjunction with last access time tracking policy
     */
    @JsonProperty(value = "daysAfterLastAccessTimeGreaterThan")
    private Float daysAfterLastAccessTimeGreaterThan;

    /**
     * Get the daysAfterModificationGreaterThan property: Value indicating the age in days after last modification.
     *
     * @return the daysAfterModificationGreaterThan value.
     */
    public Float daysAfterModificationGreaterThan() {
        return this.daysAfterModificationGreaterThan;
    }

    /**
     * Set the daysAfterModificationGreaterThan property: Value indicating the age in days after last modification.
     *
     * @param daysAfterModificationGreaterThan the daysAfterModificationGreaterThan value to set.
     * @return the DateAfterModification object itself.
     */
    public DateAfterModification withDaysAfterModificationGreaterThan(Float daysAfterModificationGreaterThan) {
        this.daysAfterModificationGreaterThan = daysAfterModificationGreaterThan;
        return this;
    }

    /**
     * Get the daysAfterLastAccessTimeGreaterThan property: Value indicating the age in days after last blob access.
     * This property can only be used in conjunction with last access time tracking policy.
     *
     * @return the daysAfterLastAccessTimeGreaterThan value.
     */
    public Float daysAfterLastAccessTimeGreaterThan() {
        return this.daysAfterLastAccessTimeGreaterThan;
    }

    /**
     * Set the daysAfterLastAccessTimeGreaterThan property: Value indicating the age in days after last blob access.
     * This property can only be used in conjunction with last access time tracking policy.
     *
     * @param daysAfterLastAccessTimeGreaterThan the daysAfterLastAccessTimeGreaterThan value to set.
     * @return the DateAfterModification object itself.
     */
    public DateAfterModification withDaysAfterLastAccessTimeGreaterThan(Float daysAfterLastAccessTimeGreaterThan) {
        this.daysAfterLastAccessTimeGreaterThan = daysAfterLastAccessTimeGreaterThan;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
