/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.storage.fluent.QueueServicesClient;
import com.azure.resourcemanager.storage.fluent.models.ListQueueServicesInner;
import com.azure.resourcemanager.storage.fluent.models.QueueServicePropertiesInner;
import com.azure.resourcemanager.storage.implementation.StorageManagementClientImpl;
import com.azure.resourcemanager.storage.models.CorsRules;
import reactor.core.publisher.Mono;

public final class QueueServicesClientImpl
implements QueueServicesClient {
    private final ClientLogger logger = new ClientLogger(QueueServicesClientImpl.class);
    private final QueueServicesService service;
    private final StorageManagementClientImpl client;

    QueueServicesClientImpl(StorageManagementClientImpl client) {
        this.service = (QueueServicesService)RestProxy.create(QueueServicesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    public Mono<Response<ListQueueServicesInner>> listWithResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), resourceGroupName, accountName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<ListQueueServicesInner>> listWithResponseAsync(String resourceGroupName, String accountName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), resourceGroupName, accountName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    public Mono<ListQueueServicesInner> listAsync(String resourceGroupName, String accountName) {
        return this.listWithResponseAsync(resourceGroupName, accountName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((ListQueueServicesInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public ListQueueServicesInner list(String resourceGroupName, String accountName) {
        return (ListQueueServicesInner)this.listAsync(resourceGroupName, accountName).block();
    }

    @Override
    public Response<ListQueueServicesInner> listWithResponse(String resourceGroupName, String accountName, Context context) {
        return (Response)this.listWithResponseAsync(resourceGroupName, accountName, context).block();
    }

    @Override
    public Mono<Response<QueueServicePropertiesInner>> setServicePropertiesWithResponseAsync(String resourceGroupName, String accountName, CorsRules cors) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (cors != null) {
            cors.validate();
        }
        String queueServiceName = "default";
        String accept = "application/json";
        QueueServicePropertiesInner parameters = new QueueServicePropertiesInner();
        parameters.withCors(cors);
        return FluxUtil.withContext(context -> this.service.setServiceProperties(this.client.getEndpoint(), resourceGroupName, accountName, this.client.getApiVersion(), this.client.getSubscriptionId(), "default", parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<QueueServicePropertiesInner>> setServicePropertiesWithResponseAsync(String resourceGroupName, String accountName, CorsRules cors, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (cors != null) {
            cors.validate();
        }
        String queueServiceName = "default";
        String accept = "application/json";
        QueueServicePropertiesInner parameters = new QueueServicePropertiesInner();
        parameters.withCors(cors);
        context = this.client.mergeContext(context);
        return this.service.setServiceProperties(this.client.getEndpoint(), resourceGroupName, accountName, this.client.getApiVersion(), this.client.getSubscriptionId(), "default", parameters, "application/json", context);
    }

    @Override
    public Mono<QueueServicePropertiesInner> setServicePropertiesAsync(String resourceGroupName, String accountName, CorsRules cors) {
        return this.setServicePropertiesWithResponseAsync(resourceGroupName, accountName, cors).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((QueueServicePropertiesInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public Mono<QueueServicePropertiesInner> setServicePropertiesAsync(String resourceGroupName, String accountName) {
        CorsRules cors = null;
        return this.setServicePropertiesWithResponseAsync(resourceGroupName, accountName, cors).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((QueueServicePropertiesInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public QueueServicePropertiesInner setServiceProperties(String resourceGroupName, String accountName) {
        CorsRules cors = null;
        return (QueueServicePropertiesInner)((Object)this.setServicePropertiesAsync(resourceGroupName, accountName, cors).block());
    }

    @Override
    public Response<QueueServicePropertiesInner> setServicePropertiesWithResponse(String resourceGroupName, String accountName, CorsRules cors, Context context) {
        return (Response)this.setServicePropertiesWithResponseAsync(resourceGroupName, accountName, cors, context).block();
    }

    @Override
    public Mono<Response<QueueServicePropertiesInner>> getServicePropertiesWithResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String queueServiceName = "default";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getServiceProperties(this.client.getEndpoint(), resourceGroupName, accountName, this.client.getApiVersion(), this.client.getSubscriptionId(), "default", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<QueueServicePropertiesInner>> getServicePropertiesWithResponseAsync(String resourceGroupName, String accountName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String queueServiceName = "default";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getServiceProperties(this.client.getEndpoint(), resourceGroupName, accountName, this.client.getApiVersion(), this.client.getSubscriptionId(), "default", "application/json", context);
    }

    @Override
    public Mono<QueueServicePropertiesInner> getServicePropertiesAsync(String resourceGroupName, String accountName) {
        return this.getServicePropertiesWithResponseAsync(resourceGroupName, accountName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((QueueServicePropertiesInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public QueueServicePropertiesInner getServiceProperties(String resourceGroupName, String accountName) {
        return (QueueServicePropertiesInner)((Object)this.getServicePropertiesAsync(resourceGroupName, accountName).block());
    }

    @Override
    public Response<QueueServicePropertiesInner> getServicePropertiesWithResponse(String resourceGroupName, String accountName, Context context) {
        return (Response)this.getServicePropertiesWithResponseAsync(resourceGroupName, accountName, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="StorageManagementCli")
    private static interface QueueServicesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/queueServices")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ListQueueServicesInner>> list(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="accountName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/queueServices/{queueServiceName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<QueueServicePropertiesInner>> setServiceProperties(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="accountName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @PathParam(value="queueServiceName") String var6, @BodyParam(value="application/json") QueueServicePropertiesInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/queueServices/{queueServiceName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<QueueServicePropertiesInner>> getServiceProperties(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="accountName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @PathParam(value="queueServiceName") String var6, @HeaderParam(value="Accept") String var7, Context var8);
    }
}

