/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.implementation;

import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.TopLevelModifiableResourcesImpl;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import com.azure.resourcemanager.storage.StorageManager;
import com.azure.resourcemanager.storage.fluent.StorageAccountsClient;
import com.azure.resourcemanager.storage.fluent.StorageManagementClient;
import com.azure.resourcemanager.storage.fluent.models.ListServiceSasResponseInner;
import com.azure.resourcemanager.storage.fluent.models.StorageAccountInner;
import com.azure.resourcemanager.storage.implementation.StorageAccountImpl;
import com.azure.resourcemanager.storage.models.CheckNameAvailabilityResult;
import com.azure.resourcemanager.storage.models.MinimumTlsVersion;
import com.azure.resourcemanager.storage.models.ServiceSasParameters;
import com.azure.resourcemanager.storage.models.StorageAccount;
import com.azure.resourcemanager.storage.models.StorageAccountSkuType;
import com.azure.resourcemanager.storage.models.StorageAccounts;
import reactor.core.publisher.Mono;

public class StorageAccountsImpl
extends TopLevelModifiableResourcesImpl<StorageAccount, StorageAccountImpl, StorageAccountInner, StorageAccountsClient, StorageManager>
implements StorageAccounts {
    public StorageAccountsImpl(StorageManager storageManager) {
        super((InnerSupportsListing)((StorageManagementClient)storageManager.serviceClient()).getStorageAccounts(), (Manager)storageManager);
    }

    @Override
    public CheckNameAvailabilityResult checkNameAvailability(String name) {
        return (CheckNameAvailabilityResult)this.checkNameAvailabilityAsync(name).block();
    }

    @Override
    public Mono<CheckNameAvailabilityResult> checkNameAvailabilityAsync(String name) {
        return ((StorageAccountsClient)this.inner()).checkNameAvailabilityAsync(name).map(CheckNameAvailabilityResult::new);
    }

    public StorageAccountImpl define(String name) {
        return this.wrapModel(name).withSku(StorageAccountSkuType.STANDARD_RAGRS).withGeneralPurposeAccountKindV2().withOnlyHttpsTraffic().withMinimumTlsVersion(MinimumTlsVersion.TLS1_2);
    }

    protected StorageAccountImpl wrapModel(String name) {
        return new StorageAccountImpl(name, new StorageAccountInner(), (StorageManager)this.manager());
    }

    protected StorageAccountImpl wrapModel(StorageAccountInner storageAccountInner) {
        if (storageAccountInner == null) {
            return null;
        }
        return new StorageAccountImpl(storageAccountInner.name(), storageAccountInner, (StorageManager)this.manager());
    }

    @Override
    public String createSasToken(String resourceGroupName, String accountName, ServiceSasParameters parameters) {
        return (String)this.createSasTokenAsync(resourceGroupName, accountName, parameters).block();
    }

    @Override
    public Mono<String> createSasTokenAsync(String resourceGroupName, String accountName, ServiceSasParameters parameters) {
        return ((StorageAccountsClient)this.inner()).listServiceSasAsync(resourceGroupName, accountName, parameters).map(ListServiceSasResponseInner::serviceSasToken);
    }

    @Override
    public void failover(String resourceGroupName, String accountName) {
        this.failoverAsync(resourceGroupName, accountName).block();
    }

    @Override
    public Mono<Void> failoverAsync(String resourceGroupName, String accountName) {
        return ((StorageAccountsClient)this.inner()).failoverAsync(resourceGroupName, accountName);
    }
}

