/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.storage.fluent.models.StorageAccountMigrationProperties;
import com.azure.resourcemanager.storage.models.MigrationStatus;
import com.azure.resourcemanager.storage.models.SkuName;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class StorageAccountMigrationInner {
    @JsonProperty(value="id", access=JsonProperty.Access.WRITE_ONLY)
    private String id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="type")
    private String type;
    @JsonProperty(value="properties", required=true)
    private StorageAccountMigrationProperties innerStorageAccountMigrationDetails = new StorageAccountMigrationProperties();
    private static final ClientLogger LOGGER = new ClientLogger(StorageAccountMigrationInner.class);

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public StorageAccountMigrationInner withName(String name) {
        this.name = name;
        return this;
    }

    public String type() {
        return this.type;
    }

    public StorageAccountMigrationInner withType(String type) {
        this.type = type;
        return this;
    }

    private StorageAccountMigrationProperties innerStorageAccountMigrationDetails() {
        return this.innerStorageAccountMigrationDetails;
    }

    public SkuName targetSkuName() {
        return this.innerStorageAccountMigrationDetails() == null ? null : this.innerStorageAccountMigrationDetails().targetSkuName();
    }

    public StorageAccountMigrationInner withTargetSkuName(SkuName targetSkuName) {
        if (this.innerStorageAccountMigrationDetails() == null) {
            this.innerStorageAccountMigrationDetails = new StorageAccountMigrationProperties();
        }
        this.innerStorageAccountMigrationDetails().withTargetSkuName(targetSkuName);
        return this;
    }

    public MigrationStatus migrationStatus() {
        return this.innerStorageAccountMigrationDetails() == null ? null : this.innerStorageAccountMigrationDetails().migrationStatus();
    }

    public String migrationFailedReason() {
        return this.innerStorageAccountMigrationDetails() == null ? null : this.innerStorageAccountMigrationDetails().migrationFailedReason();
    }

    public String migrationFailedDetailedReason() {
        return this.innerStorageAccountMigrationDetails() == null ? null : this.innerStorageAccountMigrationDetails().migrationFailedDetailedReason();
    }

    public void validate() {
        if (this.innerStorageAccountMigrationDetails() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerStorageAccountMigrationDetails in model StorageAccountMigrationInner"));
        }
        this.innerStorageAccountMigrationDetails().validate();
    }
}

