/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.storage.models.BlobInventoryPolicyFilter;
import com.azure.resourcemanager.storage.models.Format;
import com.azure.resourcemanager.storage.models.ObjectType;
import com.azure.resourcemanager.storage.models.Schedule;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class BlobInventoryPolicyDefinition {
    @JsonProperty(value="filters")
    private BlobInventoryPolicyFilter filters;
    @JsonProperty(value="format", required=true)
    private Format format;
    @JsonProperty(value="schedule", required=true)
    private Schedule schedule;
    @JsonProperty(value="objectType", required=true)
    private ObjectType objectType;
    @JsonProperty(value="schemaFields", required=true)
    private List<String> schemaFields;
    private static final ClientLogger LOGGER = new ClientLogger(BlobInventoryPolicyDefinition.class);

    public BlobInventoryPolicyFilter filters() {
        return this.filters;
    }

    public BlobInventoryPolicyDefinition withFilters(BlobInventoryPolicyFilter filters) {
        this.filters = filters;
        return this;
    }

    public Format format() {
        return this.format;
    }

    public BlobInventoryPolicyDefinition withFormat(Format format) {
        this.format = format;
        return this;
    }

    public Schedule schedule() {
        return this.schedule;
    }

    public BlobInventoryPolicyDefinition withSchedule(Schedule schedule) {
        this.schedule = schedule;
        return this;
    }

    public ObjectType objectType() {
        return this.objectType;
    }

    public BlobInventoryPolicyDefinition withObjectType(ObjectType objectType) {
        this.objectType = objectType;
        return this;
    }

    public List<String> schemaFields() {
        return this.schemaFields;
    }

    public BlobInventoryPolicyDefinition withSchemaFields(List<String> schemaFields) {
        this.schemaFields = schemaFields;
        return this;
    }

    public void validate() {
        if (this.filters() != null) {
            this.filters().validate();
        }
        if (this.format() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property format in model BlobInventoryPolicyDefinition"));
        }
        if (this.schedule() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property schedule in model BlobInventoryPolicyDefinition"));
        }
        if (this.objectType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property objectType in model BlobInventoryPolicyDefinition"));
        }
        if (this.schemaFields() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property schemaFields in model BlobInventoryPolicyDefinition"));
        }
    }
}

