/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.storage.models.ProvisioningState;
import com.azure.resourcemanager.storage.models.StorageTaskAssignmentExecutionContext;
import com.azure.resourcemanager.storage.models.StorageTaskAssignmentReport;
import com.azure.resourcemanager.storage.models.StorageTaskReportProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class StorageTaskAssignmentProperties {
    @JsonProperty(value="taskId", required=true)
    private String taskId;
    @JsonProperty(value="enabled", required=true)
    private boolean enabled;
    @JsonProperty(value="description", required=true)
    private String description;
    @JsonProperty(value="executionContext", required=true)
    private StorageTaskAssignmentExecutionContext executionContext;
    @JsonProperty(value="report", required=true)
    private StorageTaskAssignmentReport report;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="runStatus")
    private StorageTaskReportProperties runStatus;
    private static final ClientLogger LOGGER = new ClientLogger(StorageTaskAssignmentProperties.class);

    public String taskId() {
        return this.taskId;
    }

    public StorageTaskAssignmentProperties withTaskId(String taskId) {
        this.taskId = taskId;
        return this;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public StorageTaskAssignmentProperties withEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public String description() {
        return this.description;
    }

    public StorageTaskAssignmentProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public StorageTaskAssignmentExecutionContext executionContext() {
        return this.executionContext;
    }

    public StorageTaskAssignmentProperties withExecutionContext(StorageTaskAssignmentExecutionContext executionContext) {
        this.executionContext = executionContext;
        return this;
    }

    public StorageTaskAssignmentReport report() {
        return this.report;
    }

    public StorageTaskAssignmentProperties withReport(StorageTaskAssignmentReport report) {
        this.report = report;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public StorageTaskReportProperties runStatus() {
        return this.runStatus;
    }

    public StorageTaskAssignmentProperties withRunStatus(StorageTaskReportProperties runStatus) {
        this.runStatus = runStatus;
        return this;
    }

    public void validate() {
        if (this.taskId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property taskId in model StorageTaskAssignmentProperties"));
        }
        if (this.description() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property description in model StorageTaskAssignmentProperties"));
        }
        if (this.executionContext() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property executionContext in model StorageTaskAssignmentProperties"));
        }
        this.executionContext().validate();
        if (this.report() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property report in model StorageTaskAssignmentProperties"));
        }
        this.report().validate();
        if (this.runStatus() != null) {
            this.runStatus().validate();
        }
    }
}

