// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Object to define snapshot and version action conditions.
 */
@Fluent
public final class DateAfterCreation implements JsonSerializable<DateAfterCreation> {
    /*
     * Value indicating the age in days after creation
     */
    private float daysAfterCreationGreaterThan;

    /*
     * Value indicating the age in days after last blob tier change time. This property is only applicable for
     * tierToArchive actions and requires daysAfterCreationGreaterThan to be set for snapshots and blob version based
     * actions. The blob will be archived if both the conditions are satisfied.
     */
    private Float daysAfterLastTierChangeGreaterThan;

    /**
     * Creates an instance of DateAfterCreation class.
     */
    public DateAfterCreation() {
    }

    /**
     * Get the daysAfterCreationGreaterThan property: Value indicating the age in days after creation.
     * 
     * @return the daysAfterCreationGreaterThan value.
     */
    public float daysAfterCreationGreaterThan() {
        return this.daysAfterCreationGreaterThan;
    }

    /**
     * Set the daysAfterCreationGreaterThan property: Value indicating the age in days after creation.
     * 
     * @param daysAfterCreationGreaterThan the daysAfterCreationGreaterThan value to set.
     * @return the DateAfterCreation object itself.
     */
    public DateAfterCreation withDaysAfterCreationGreaterThan(float daysAfterCreationGreaterThan) {
        this.daysAfterCreationGreaterThan = daysAfterCreationGreaterThan;
        return this;
    }

    /**
     * Get the daysAfterLastTierChangeGreaterThan property: Value indicating the age in days after last blob tier change
     * time. This property is only applicable for tierToArchive actions and requires daysAfterCreationGreaterThan to be
     * set for snapshots and blob version based actions. The blob will be archived if both the conditions are satisfied.
     * 
     * @return the daysAfterLastTierChangeGreaterThan value.
     */
    public Float daysAfterLastTierChangeGreaterThan() {
        return this.daysAfterLastTierChangeGreaterThan;
    }

    /**
     * Set the daysAfterLastTierChangeGreaterThan property: Value indicating the age in days after last blob tier change
     * time. This property is only applicable for tierToArchive actions and requires daysAfterCreationGreaterThan to be
     * set for snapshots and blob version based actions. The blob will be archived if both the conditions are satisfied.
     * 
     * @param daysAfterLastTierChangeGreaterThan the daysAfterLastTierChangeGreaterThan value to set.
     * @return the DateAfterCreation object itself.
     */
    public DateAfterCreation withDaysAfterLastTierChangeGreaterThan(Float daysAfterLastTierChangeGreaterThan) {
        this.daysAfterLastTierChangeGreaterThan = daysAfterLastTierChangeGreaterThan;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeFloatField("daysAfterCreationGreaterThan", this.daysAfterCreationGreaterThan);
        jsonWriter.writeNumberField("daysAfterLastTierChangeGreaterThan", this.daysAfterLastTierChangeGreaterThan);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DateAfterCreation from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DateAfterCreation if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DateAfterCreation.
     */
    public static DateAfterCreation fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DateAfterCreation deserializedDateAfterCreation = new DateAfterCreation();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("daysAfterCreationGreaterThan".equals(fieldName)) {
                    deserializedDateAfterCreation.daysAfterCreationGreaterThan = reader.getFloat();
                } else if ("daysAfterLastTierChangeGreaterThan".equals(fieldName)) {
                    deserializedDateAfterCreation.daysAfterLastTierChangeGreaterThan
                        = reader.getNullable(JsonReader::getFloat);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDateAfterCreation;
        });
    }
}
