// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

/**
 * The protocol permitted for a request made with the account SAS.
 */
public enum HttpProtocol {
    /**
     * Enum value https,http.
     */
    HTTPS_HTTP("https,http"),

    /**
     * Enum value https.
     */
    HTTPS("https");

    /**
     * The actual serialized value for a HttpProtocol instance.
     */
    private final String value;

    HttpProtocol(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a HttpProtocol instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed HttpProtocol object, or null if unable to parse.
     */
    public static HttpProtocol fromString(String value) {
        if (value == null) {
            return null;
        }
        HttpProtocol[] items = HttpProtocol.values();
        for (HttpProtocol item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
