/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.models.ImmutabilityPolicyProperties;
import com.azure.resourcemanager.storage.models.ImmutableStorageWithVersioning;
import com.azure.resourcemanager.storage.models.LeaseDuration;
import com.azure.resourcemanager.storage.models.LeaseState;
import com.azure.resourcemanager.storage.models.LeaseStatus;
import com.azure.resourcemanager.storage.models.LegalHoldProperties;
import com.azure.resourcemanager.storage.models.PublicAccess;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;

public final class ContainerProperties
implements JsonSerializable<ContainerProperties> {
    private String version;
    private Boolean deleted;
    private OffsetDateTime deletedTime;
    private Integer remainingRetentionDays;
    private String defaultEncryptionScope;
    private Boolean denyEncryptionScopeOverride;
    private PublicAccess publicAccess;
    private OffsetDateTime lastModifiedTime;
    private LeaseStatus leaseStatus;
    private LeaseState leaseState;
    private LeaseDuration leaseDuration;
    private Map<String, String> metadata;
    private ImmutabilityPolicyProperties immutabilityPolicy;
    private LegalHoldProperties legalHold;
    private Boolean hasLegalHold;
    private Boolean hasImmutabilityPolicy;
    private ImmutableStorageWithVersioning immutableStorageWithVersioning;
    private Boolean enableNfsV3RootSquash;
    private Boolean enableNfsV3AllSquash;

    public String version() {
        return this.version;
    }

    public Boolean deleted() {
        return this.deleted;
    }

    public OffsetDateTime deletedTime() {
        return this.deletedTime;
    }

    public Integer remainingRetentionDays() {
        return this.remainingRetentionDays;
    }

    public String defaultEncryptionScope() {
        return this.defaultEncryptionScope;
    }

    public ContainerProperties withDefaultEncryptionScope(String defaultEncryptionScope) {
        this.defaultEncryptionScope = defaultEncryptionScope;
        return this;
    }

    public Boolean denyEncryptionScopeOverride() {
        return this.denyEncryptionScopeOverride;
    }

    public ContainerProperties withDenyEncryptionScopeOverride(Boolean denyEncryptionScopeOverride) {
        this.denyEncryptionScopeOverride = denyEncryptionScopeOverride;
        return this;
    }

    public PublicAccess publicAccess() {
        return this.publicAccess;
    }

    public ContainerProperties withPublicAccess(PublicAccess publicAccess) {
        this.publicAccess = publicAccess;
        return this;
    }

    public OffsetDateTime lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public LeaseStatus leaseStatus() {
        return this.leaseStatus;
    }

    public LeaseState leaseState() {
        return this.leaseState;
    }

    public LeaseDuration leaseDuration() {
        return this.leaseDuration;
    }

    public Map<String, String> metadata() {
        return this.metadata;
    }

    public ContainerProperties withMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public ImmutabilityPolicyProperties immutabilityPolicy() {
        return this.immutabilityPolicy;
    }

    public LegalHoldProperties legalHold() {
        return this.legalHold;
    }

    public Boolean hasLegalHold() {
        return this.hasLegalHold;
    }

    public Boolean hasImmutabilityPolicy() {
        return this.hasImmutabilityPolicy;
    }

    public ImmutableStorageWithVersioning immutableStorageWithVersioning() {
        return this.immutableStorageWithVersioning;
    }

    public ContainerProperties withImmutableStorageWithVersioning(ImmutableStorageWithVersioning immutableStorageWithVersioning) {
        this.immutableStorageWithVersioning = immutableStorageWithVersioning;
        return this;
    }

    public Boolean enableNfsV3RootSquash() {
        return this.enableNfsV3RootSquash;
    }

    public ContainerProperties withEnableNfsV3RootSquash(Boolean enableNfsV3RootSquash) {
        this.enableNfsV3RootSquash = enableNfsV3RootSquash;
        return this;
    }

    public Boolean enableNfsV3AllSquash() {
        return this.enableNfsV3AllSquash;
    }

    public ContainerProperties withEnableNfsV3AllSquash(Boolean enableNfsV3AllSquash) {
        this.enableNfsV3AllSquash = enableNfsV3AllSquash;
        return this;
    }

    public void validate() {
        if (this.immutabilityPolicy() != null) {
            this.immutabilityPolicy().validate();
        }
        if (this.legalHold() != null) {
            this.legalHold().validate();
        }
        if (this.immutableStorageWithVersioning() != null) {
            this.immutableStorageWithVersioning().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("defaultEncryptionScope", this.defaultEncryptionScope);
        jsonWriter.writeBooleanField("denyEncryptionScopeOverride", this.denyEncryptionScopeOverride);
        jsonWriter.writeStringField("publicAccess", this.publicAccess == null ? null : this.publicAccess.toString());
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("immutableStorageWithVersioning", (JsonSerializable)this.immutableStorageWithVersioning);
        jsonWriter.writeBooleanField("enableNfsV3RootSquash", this.enableNfsV3RootSquash);
        jsonWriter.writeBooleanField("enableNfsV3AllSquash", this.enableNfsV3AllSquash);
        return jsonWriter.writeEndObject();
    }

    public static ContainerProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ContainerProperties)jsonReader.readObject(reader -> {
            ContainerProperties deserializedContainerProperties = new ContainerProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedContainerProperties.version = reader.getString();
                    continue;
                }
                if ("deleted".equals(fieldName)) {
                    deserializedContainerProperties.deleted = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("deletedTime".equals(fieldName)) {
                    deserializedContainerProperties.deletedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("remainingRetentionDays".equals(fieldName)) {
                    deserializedContainerProperties.remainingRetentionDays = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("defaultEncryptionScope".equals(fieldName)) {
                    deserializedContainerProperties.defaultEncryptionScope = reader.getString();
                    continue;
                }
                if ("denyEncryptionScopeOverride".equals(fieldName)) {
                    deserializedContainerProperties.denyEncryptionScopeOverride = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("publicAccess".equals(fieldName)) {
                    deserializedContainerProperties.publicAccess = PublicAccess.fromString(reader.getString());
                    continue;
                }
                if ("lastModifiedTime".equals(fieldName)) {
                    deserializedContainerProperties.lastModifiedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("leaseStatus".equals(fieldName)) {
                    deserializedContainerProperties.leaseStatus = LeaseStatus.fromString(reader.getString());
                    continue;
                }
                if ("leaseState".equals(fieldName)) {
                    deserializedContainerProperties.leaseState = LeaseState.fromString(reader.getString());
                    continue;
                }
                if ("leaseDuration".equals(fieldName)) {
                    deserializedContainerProperties.leaseDuration = LeaseDuration.fromString(reader.getString());
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    Map metadata;
                    deserializedContainerProperties.metadata = metadata = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("immutabilityPolicy".equals(fieldName)) {
                    deserializedContainerProperties.immutabilityPolicy = ImmutabilityPolicyProperties.fromJson(reader);
                    continue;
                }
                if ("legalHold".equals(fieldName)) {
                    deserializedContainerProperties.legalHold = LegalHoldProperties.fromJson(reader);
                    continue;
                }
                if ("hasLegalHold".equals(fieldName)) {
                    deserializedContainerProperties.hasLegalHold = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("hasImmutabilityPolicy".equals(fieldName)) {
                    deserializedContainerProperties.hasImmutabilityPolicy = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("immutableStorageWithVersioning".equals(fieldName)) {
                    deserializedContainerProperties.immutableStorageWithVersioning = ImmutableStorageWithVersioning.fromJson(reader);
                    continue;
                }
                if ("enableNfsV3RootSquash".equals(fieldName)) {
                    deserializedContainerProperties.enableNfsV3RootSquash = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("enableNfsV3AllSquash".equals(fieldName)) {
                    deserializedContainerProperties.enableNfsV3AllSquash = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedContainerProperties;
        });
    }
}

