// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.models.EnabledProtocols;
import com.azure.resourcemanager.storage.models.LeaseDuration;
import com.azure.resourcemanager.storage.models.LeaseState;
import com.azure.resourcemanager.storage.models.LeaseStatus;
import com.azure.resourcemanager.storage.models.RootSquashType;
import com.azure.resourcemanager.storage.models.ShareAccessTier;
import com.azure.resourcemanager.storage.models.SignedIdentifier;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

/**
 * The properties of the file share.
 */
@Fluent
public final class FileShareProperties implements JsonSerializable<FileShareProperties> {
    /*
     * Returns the date and time the share was last modified.
     */
    private OffsetDateTime lastModifiedTime;

    /*
     * A name-value pair to associate with the share as metadata.
     */
    private Map<String, String> metadata;

    /*
     * The maximum size of the share, in gigabytes. Must be greater than 0, and less than or equal to 5TB (5120). For
     * Large File Shares, the maximum size is 102400.
     */
    private Integer shareQuota;

    /*
     * The authentication protocol that is used for the file share. Can only be specified when creating a share.
     */
    private EnabledProtocols enabledProtocols;

    /*
     * The property is for NFS share only. The default is NoRootSquash.
     */
    private RootSquashType rootSquash;

    /*
     * The version of the share.
     */
    private String version;

    /*
     * Indicates whether the share was deleted.
     */
    private Boolean deleted;

    /*
     * The deleted time if the share was deleted.
     */
    private OffsetDateTime deletedTime;

    /*
     * Remaining retention days for share that was soft deleted.
     */
    private Integer remainingRetentionDays;

    /*
     * Access tier for specific share. GpV2 account can choose between TransactionOptimized (default), Hot, and Cool.
     * FileStorage account can choose Premium.
     */
    private ShareAccessTier accessTier;

    /*
     * Indicates the last modification time for share access tier.
     */
    private OffsetDateTime accessTierChangeTime;

    /*
     * Indicates if there is a pending transition for access tier.
     */
    private String accessTierStatus;

    /*
     * The approximate size of the data stored on the share. Note that this value may not include all recently created
     * or recently resized files.
     */
    private Long shareUsageBytes;

    /*
     * The lease status of the share.
     */
    private LeaseStatus leaseStatus;

    /*
     * Lease state of the share.
     */
    private LeaseState leaseState;

    /*
     * Specifies whether the lease on a share is of infinite or fixed duration, only when the share is leased.
     */
    private LeaseDuration leaseDuration;

    /*
     * List of stored access policies specified on the share.
     */
    private List<SignedIdentifier> signedIdentifiers;

    /*
     * Creation time of share snapshot returned in the response of list shares with expand param "snapshots".
     */
    private OffsetDateTime snapshotTime;

    /**
     * Creates an instance of FileShareProperties class.
     */
    public FileShareProperties() {
    }

    /**
     * Get the lastModifiedTime property: Returns the date and time the share was last modified.
     * 
     * @return the lastModifiedTime value.
     */
    public OffsetDateTime lastModifiedTime() {
        return this.lastModifiedTime;
    }

    /**
     * Get the metadata property: A name-value pair to associate with the share as metadata.
     * 
     * @return the metadata value.
     */
    public Map<String, String> metadata() {
        return this.metadata;
    }

    /**
     * Set the metadata property: A name-value pair to associate with the share as metadata.
     * 
     * @param metadata the metadata value to set.
     * @return the FileShareProperties object itself.
     */
    public FileShareProperties withMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    /**
     * Get the shareQuota property: The maximum size of the share, in gigabytes. Must be greater than 0, and less than
     * or equal to 5TB (5120). For Large File Shares, the maximum size is 102400.
     * 
     * @return the shareQuota value.
     */
    public Integer shareQuota() {
        return this.shareQuota;
    }

    /**
     * Set the shareQuota property: The maximum size of the share, in gigabytes. Must be greater than 0, and less than
     * or equal to 5TB (5120). For Large File Shares, the maximum size is 102400.
     * 
     * @param shareQuota the shareQuota value to set.
     * @return the FileShareProperties object itself.
     */
    public FileShareProperties withShareQuota(Integer shareQuota) {
        this.shareQuota = shareQuota;
        return this;
    }

    /**
     * Get the enabledProtocols property: The authentication protocol that is used for the file share. Can only be
     * specified when creating a share.
     * 
     * @return the enabledProtocols value.
     */
    public EnabledProtocols enabledProtocols() {
        return this.enabledProtocols;
    }

    /**
     * Set the enabledProtocols property: The authentication protocol that is used for the file share. Can only be
     * specified when creating a share.
     * 
     * @param enabledProtocols the enabledProtocols value to set.
     * @return the FileShareProperties object itself.
     */
    public FileShareProperties withEnabledProtocols(EnabledProtocols enabledProtocols) {
        this.enabledProtocols = enabledProtocols;
        return this;
    }

    /**
     * Get the rootSquash property: The property is for NFS share only. The default is NoRootSquash.
     * 
     * @return the rootSquash value.
     */
    public RootSquashType rootSquash() {
        return this.rootSquash;
    }

    /**
     * Set the rootSquash property: The property is for NFS share only. The default is NoRootSquash.
     * 
     * @param rootSquash the rootSquash value to set.
     * @return the FileShareProperties object itself.
     */
    public FileShareProperties withRootSquash(RootSquashType rootSquash) {
        this.rootSquash = rootSquash;
        return this;
    }

    /**
     * Get the version property: The version of the share.
     * 
     * @return the version value.
     */
    public String version() {
        return this.version;
    }

    /**
     * Get the deleted property: Indicates whether the share was deleted.
     * 
     * @return the deleted value.
     */
    public Boolean deleted() {
        return this.deleted;
    }

    /**
     * Get the deletedTime property: The deleted time if the share was deleted.
     * 
     * @return the deletedTime value.
     */
    public OffsetDateTime deletedTime() {
        return this.deletedTime;
    }

    /**
     * Get the remainingRetentionDays property: Remaining retention days for share that was soft deleted.
     * 
     * @return the remainingRetentionDays value.
     */
    public Integer remainingRetentionDays() {
        return this.remainingRetentionDays;
    }

    /**
     * Get the accessTier property: Access tier for specific share. GpV2 account can choose between TransactionOptimized
     * (default), Hot, and Cool. FileStorage account can choose Premium.
     * 
     * @return the accessTier value.
     */
    public ShareAccessTier accessTier() {
        return this.accessTier;
    }

    /**
     * Set the accessTier property: Access tier for specific share. GpV2 account can choose between TransactionOptimized
     * (default), Hot, and Cool. FileStorage account can choose Premium.
     * 
     * @param accessTier the accessTier value to set.
     * @return the FileShareProperties object itself.
     */
    public FileShareProperties withAccessTier(ShareAccessTier accessTier) {
        this.accessTier = accessTier;
        return this;
    }

    /**
     * Get the accessTierChangeTime property: Indicates the last modification time for share access tier.
     * 
     * @return the accessTierChangeTime value.
     */
    public OffsetDateTime accessTierChangeTime() {
        return this.accessTierChangeTime;
    }

    /**
     * Get the accessTierStatus property: Indicates if there is a pending transition for access tier.
     * 
     * @return the accessTierStatus value.
     */
    public String accessTierStatus() {
        return this.accessTierStatus;
    }

    /**
     * Get the shareUsageBytes property: The approximate size of the data stored on the share. Note that this value may
     * not include all recently created or recently resized files.
     * 
     * @return the shareUsageBytes value.
     */
    public Long shareUsageBytes() {
        return this.shareUsageBytes;
    }

    /**
     * Get the leaseStatus property: The lease status of the share.
     * 
     * @return the leaseStatus value.
     */
    public LeaseStatus leaseStatus() {
        return this.leaseStatus;
    }

    /**
     * Get the leaseState property: Lease state of the share.
     * 
     * @return the leaseState value.
     */
    public LeaseState leaseState() {
        return this.leaseState;
    }

    /**
     * Get the leaseDuration property: Specifies whether the lease on a share is of infinite or fixed duration, only
     * when the share is leased.
     * 
     * @return the leaseDuration value.
     */
    public LeaseDuration leaseDuration() {
        return this.leaseDuration;
    }

    /**
     * Get the signedIdentifiers property: List of stored access policies specified on the share.
     * 
     * @return the signedIdentifiers value.
     */
    public List<SignedIdentifier> signedIdentifiers() {
        return this.signedIdentifiers;
    }

    /**
     * Set the signedIdentifiers property: List of stored access policies specified on the share.
     * 
     * @param signedIdentifiers the signedIdentifiers value to set.
     * @return the FileShareProperties object itself.
     */
    public FileShareProperties withSignedIdentifiers(List<SignedIdentifier> signedIdentifiers) {
        this.signedIdentifiers = signedIdentifiers;
        return this;
    }

    /**
     * Get the snapshotTime property: Creation time of share snapshot returned in the response of list shares with
     * expand param "snapshots".
     * 
     * @return the snapshotTime value.
     */
    public OffsetDateTime snapshotTime() {
        return this.snapshotTime;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (signedIdentifiers() != null) {
            signedIdentifiers().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        jsonWriter.writeNumberField("shareQuota", this.shareQuota);
        jsonWriter.writeStringField("enabledProtocols",
            this.enabledProtocols == null ? null : this.enabledProtocols.toString());
        jsonWriter.writeStringField("rootSquash", this.rootSquash == null ? null : this.rootSquash.toString());
        jsonWriter.writeStringField("accessTier", this.accessTier == null ? null : this.accessTier.toString());
        jsonWriter.writeArrayField("signedIdentifiers", this.signedIdentifiers,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FileShareProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FileShareProperties if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the FileShareProperties.
     */
    public static FileShareProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FileShareProperties deserializedFileShareProperties = new FileShareProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("lastModifiedTime".equals(fieldName)) {
                    deserializedFileShareProperties.lastModifiedTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("metadata".equals(fieldName)) {
                    Map<String, String> metadata = reader.readMap(reader1 -> reader1.getString());
                    deserializedFileShareProperties.metadata = metadata;
                } else if ("shareQuota".equals(fieldName)) {
                    deserializedFileShareProperties.shareQuota = reader.getNullable(JsonReader::getInt);
                } else if ("enabledProtocols".equals(fieldName)) {
                    deserializedFileShareProperties.enabledProtocols = EnabledProtocols.fromString(reader.getString());
                } else if ("rootSquash".equals(fieldName)) {
                    deserializedFileShareProperties.rootSquash = RootSquashType.fromString(reader.getString());
                } else if ("version".equals(fieldName)) {
                    deserializedFileShareProperties.version = reader.getString();
                } else if ("deleted".equals(fieldName)) {
                    deserializedFileShareProperties.deleted = reader.getNullable(JsonReader::getBoolean);
                } else if ("deletedTime".equals(fieldName)) {
                    deserializedFileShareProperties.deletedTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("remainingRetentionDays".equals(fieldName)) {
                    deserializedFileShareProperties.remainingRetentionDays = reader.getNullable(JsonReader::getInt);
                } else if ("accessTier".equals(fieldName)) {
                    deserializedFileShareProperties.accessTier = ShareAccessTier.fromString(reader.getString());
                } else if ("accessTierChangeTime".equals(fieldName)) {
                    deserializedFileShareProperties.accessTierChangeTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("accessTierStatus".equals(fieldName)) {
                    deserializedFileShareProperties.accessTierStatus = reader.getString();
                } else if ("shareUsageBytes".equals(fieldName)) {
                    deserializedFileShareProperties.shareUsageBytes = reader.getNullable(JsonReader::getLong);
                } else if ("leaseStatus".equals(fieldName)) {
                    deserializedFileShareProperties.leaseStatus = LeaseStatus.fromString(reader.getString());
                } else if ("leaseState".equals(fieldName)) {
                    deserializedFileShareProperties.leaseState = LeaseState.fromString(reader.getString());
                } else if ("leaseDuration".equals(fieldName)) {
                    deserializedFileShareProperties.leaseDuration = LeaseDuration.fromString(reader.getString());
                } else if ("signedIdentifiers".equals(fieldName)) {
                    List<SignedIdentifier> signedIdentifiers
                        = reader.readArray(reader1 -> SignedIdentifier.fromJson(reader1));
                    deserializedFileShareProperties.signedIdentifiers = signedIdentifiers;
                } else if ("snapshotTime".equals(fieldName)) {
                    deserializedFileShareProperties.snapshotTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedFileShareProperties;
        });
    }
}
