// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.models.ManagementPolicySchema;
import java.io.IOException;
import java.time.OffsetDateTime;

/**
 * The Get Storage Account ManagementPolicies operation response.
 */
@Fluent
public final class ManagementPolicyInner extends ProxyResource {
    /*
     * Returns the Storage Account Data Policies Rules.
     */
    private ManagementPolicyProperties innerProperties;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * The type of the resource.
     */
    private String type;

    /**
     * Creates an instance of ManagementPolicyInner class.
     */
    public ManagementPolicyInner() {
    }

    /**
     * Get the innerProperties property: Returns the Storage Account Data Policies Rules.
     * 
     * @return the innerProperties value.
     */
    private ManagementPolicyProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the lastModifiedTime property: Returns the date and time the ManagementPolicies was last modified.
     * 
     * @return the lastModifiedTime value.
     */
    public OffsetDateTime lastModifiedTime() {
        return this.innerProperties() == null ? null : this.innerProperties().lastModifiedTime();
    }

    /**
     * Get the policy property: The Storage Account ManagementPolicy, in JSON format. See more details in:
     * https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.
     * 
     * @return the policy value.
     */
    public ManagementPolicySchema policy() {
        return this.innerProperties() == null ? null : this.innerProperties().policy();
    }

    /**
     * Set the policy property: The Storage Account ManagementPolicy, in JSON format. See more details in:
     * https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.
     * 
     * @param policy the policy value to set.
     * @return the ManagementPolicyInner object itself.
     */
    public ManagementPolicyInner withPolicy(ManagementPolicySchema policy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagementPolicyProperties();
        }
        this.innerProperties().withPolicy(policy);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagementPolicyInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagementPolicyInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ManagementPolicyInner.
     */
    public static ManagementPolicyInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagementPolicyInner deserializedManagementPolicyInner = new ManagementPolicyInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedManagementPolicyInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedManagementPolicyInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedManagementPolicyInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedManagementPolicyInner.innerProperties = ManagementPolicyProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagementPolicyInner;
        });
    }
}
