// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Execution trigger for storage task assignment.
 */
@Fluent
public final class ExecutionTrigger implements JsonSerializable<ExecutionTrigger> {
    /*
     * The trigger type of the storage task assignment execution
     */
    private TriggerType type;

    /*
     * The trigger parameters of the storage task assignment execution
     */
    private TriggerParameters parameters;

    /**
     * Creates an instance of ExecutionTrigger class.
     */
    public ExecutionTrigger() {
    }

    /**
     * Get the type property: The trigger type of the storage task assignment execution.
     * 
     * @return the type value.
     */
    public TriggerType type() {
        return this.type;
    }

    /**
     * Set the type property: The trigger type of the storage task assignment execution.
     * 
     * @param type the type value to set.
     * @return the ExecutionTrigger object itself.
     */
    public ExecutionTrigger withType(TriggerType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the parameters property: The trigger parameters of the storage task assignment execution.
     * 
     * @return the parameters value.
     */
    public TriggerParameters parameters() {
        return this.parameters;
    }

    /**
     * Set the parameters property: The trigger parameters of the storage task assignment execution.
     * 
     * @param parameters the parameters value to set.
     * @return the ExecutionTrigger object itself.
     */
    public ExecutionTrigger withParameters(TriggerParameters parameters) {
        this.parameters = parameters;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (type() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property type in model ExecutionTrigger"));
        }
        if (parameters() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property parameters in model ExecutionTrigger"));
        } else {
            parameters().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ExecutionTrigger.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeJsonField("parameters", this.parameters);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ExecutionTrigger from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ExecutionTrigger if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ExecutionTrigger.
     */
    public static ExecutionTrigger fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ExecutionTrigger deserializedExecutionTrigger = new ExecutionTrigger();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("type".equals(fieldName)) {
                    deserializedExecutionTrigger.type = TriggerType.fromString(reader.getString());
                } else if ("parameters".equals(fieldName)) {
                    deserializedExecutionTrigger.parameters = TriggerParameters.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedExecutionTrigger;
        });
    }
}
