/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.fluent.models.ManagementPolicyProperties;
import com.azure.resourcemanager.storage.models.ManagementPolicySchema;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class ManagementPolicyInner
extends ProxyResource {
    private ManagementPolicyProperties innerProperties;
    private String id;
    private String name;
    private String type;

    private ManagementPolicyProperties innerProperties() {
        return this.innerProperties;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public OffsetDateTime lastModifiedTime() {
        return this.innerProperties() == null ? null : this.innerProperties().lastModifiedTime();
    }

    public ManagementPolicySchema policy() {
        return this.innerProperties() == null ? null : this.innerProperties().policy();
    }

    public ManagementPolicyInner withPolicy(ManagementPolicySchema policy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagementPolicyProperties();
        }
        this.innerProperties().withPolicy(policy);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ManagementPolicyInner fromJson(JsonReader jsonReader) throws IOException {
        return (ManagementPolicyInner)((Object)jsonReader.readObject(reader -> {
            ManagementPolicyInner deserializedManagementPolicyInner = new ManagementPolicyInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedManagementPolicyInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedManagementPolicyInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedManagementPolicyInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedManagementPolicyInner.innerProperties = ManagementPolicyProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagementPolicyInner;
        }));
    }
}

