/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.models.BlobInventoryPolicyFilter;
import com.azure.resourcemanager.storage.models.Format;
import com.azure.resourcemanager.storage.models.ObjectType;
import com.azure.resourcemanager.storage.models.Schedule;
import java.io.IOException;
import java.util.List;

public final class BlobInventoryPolicyDefinition
implements JsonSerializable<BlobInventoryPolicyDefinition> {
    private BlobInventoryPolicyFilter filters;
    private Format format;
    private Schedule schedule;
    private ObjectType objectType;
    private List<String> schemaFields;
    private static final ClientLogger LOGGER = new ClientLogger(BlobInventoryPolicyDefinition.class);

    public BlobInventoryPolicyFilter filters() {
        return this.filters;
    }

    public BlobInventoryPolicyDefinition withFilters(BlobInventoryPolicyFilter filters) {
        this.filters = filters;
        return this;
    }

    public Format format() {
        return this.format;
    }

    public BlobInventoryPolicyDefinition withFormat(Format format) {
        this.format = format;
        return this;
    }

    public Schedule schedule() {
        return this.schedule;
    }

    public BlobInventoryPolicyDefinition withSchedule(Schedule schedule) {
        this.schedule = schedule;
        return this;
    }

    public ObjectType objectType() {
        return this.objectType;
    }

    public BlobInventoryPolicyDefinition withObjectType(ObjectType objectType) {
        this.objectType = objectType;
        return this;
    }

    public List<String> schemaFields() {
        return this.schemaFields;
    }

    public BlobInventoryPolicyDefinition withSchemaFields(List<String> schemaFields) {
        this.schemaFields = schemaFields;
        return this;
    }

    public void validate() {
        if (this.filters() != null) {
            this.filters().validate();
        }
        if (this.format() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property format in model BlobInventoryPolicyDefinition"));
        }
        if (this.schedule() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property schedule in model BlobInventoryPolicyDefinition"));
        }
        if (this.objectType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property objectType in model BlobInventoryPolicyDefinition"));
        }
        if (this.schemaFields() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property schemaFields in model BlobInventoryPolicyDefinition"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("format", this.format == null ? null : this.format.toString());
        jsonWriter.writeStringField("schedule", this.schedule == null ? null : this.schedule.toString());
        jsonWriter.writeStringField("objectType", this.objectType == null ? null : this.objectType.toString());
        jsonWriter.writeArrayField("schemaFields", this.schemaFields, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("filters", (JsonSerializable)this.filters);
        return jsonWriter.writeEndObject();
    }

    public static BlobInventoryPolicyDefinition fromJson(JsonReader jsonReader) throws IOException {
        return (BlobInventoryPolicyDefinition)jsonReader.readObject(reader -> {
            BlobInventoryPolicyDefinition deserializedBlobInventoryPolicyDefinition = new BlobInventoryPolicyDefinition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("format".equals(fieldName)) {
                    deserializedBlobInventoryPolicyDefinition.format = Format.fromString(reader.getString());
                    continue;
                }
                if ("schedule".equals(fieldName)) {
                    deserializedBlobInventoryPolicyDefinition.schedule = Schedule.fromString(reader.getString());
                    continue;
                }
                if ("objectType".equals(fieldName)) {
                    deserializedBlobInventoryPolicyDefinition.objectType = ObjectType.fromString(reader.getString());
                    continue;
                }
                if ("schemaFields".equals(fieldName)) {
                    List schemaFields;
                    deserializedBlobInventoryPolicyDefinition.schemaFields = schemaFields = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("filters".equals(fieldName)) {
                    deserializedBlobInventoryPolicyDefinition.filters = BlobInventoryPolicyFilter.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBlobInventoryPolicyDefinition;
        });
    }
}

