// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.models.BlobInventoryPolicySchema;
import java.io.IOException;
import java.time.OffsetDateTime;

/**
 * The storage account blob inventory policy.
 */
@Fluent
public final class BlobInventoryPolicyInner extends ProxyResource {
    /*
     * Returns the storage account blob inventory policy rules.
     */
    private BlobInventoryPolicyProperties innerProperties;

    /*
     * Metadata pertaining to creation and last modification of the resource.
     */
    private SystemData systemData;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * The type of the resource.
     */
    private String type;

    /**
     * Creates an instance of BlobInventoryPolicyInner class.
     */
    public BlobInventoryPolicyInner() {
    }

    /**
     * Get the innerProperties property: Returns the storage account blob inventory policy rules.
     * 
     * @return the innerProperties value.
     */
    private BlobInventoryPolicyProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: Metadata pertaining to creation and last modification of the resource.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the lastModifiedTime property: Returns the last modified date and time of the blob inventory policy.
     * 
     * @return the lastModifiedTime value.
     */
    public OffsetDateTime lastModifiedTime() {
        return this.innerProperties() == null ? null : this.innerProperties().lastModifiedTime();
    }

    /**
     * Get the policy property: The storage account blob inventory policy object. It is composed of policy rules.
     * 
     * @return the policy value.
     */
    public BlobInventoryPolicySchema policy() {
        return this.innerProperties() == null ? null : this.innerProperties().policy();
    }

    /**
     * Set the policy property: The storage account blob inventory policy object. It is composed of policy rules.
     * 
     * @param policy the policy value to set.
     * @return the BlobInventoryPolicyInner object itself.
     */
    public BlobInventoryPolicyInner withPolicy(BlobInventoryPolicySchema policy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BlobInventoryPolicyProperties();
        }
        this.innerProperties().withPolicy(policy);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BlobInventoryPolicyInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BlobInventoryPolicyInner if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the BlobInventoryPolicyInner.
     */
    public static BlobInventoryPolicyInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BlobInventoryPolicyInner deserializedBlobInventoryPolicyInner = new BlobInventoryPolicyInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedBlobInventoryPolicyInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedBlobInventoryPolicyInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedBlobInventoryPolicyInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedBlobInventoryPolicyInner.innerProperties
                        = BlobInventoryPolicyProperties.fromJson(reader);
                } else if ("systemData".equals(fieldName)) {
                    deserializedBlobInventoryPolicyInner.systemData = SystemData.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBlobInventoryPolicyInner;
        });
    }
}
