// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.fluent.models.FileShareItemInner;
import java.io.IOException;
import java.util.List;

/**
 * Response schema. Contains list of shares returned, and if paging is requested or required, a URL to next page of
 * shares.
 */
@Immutable
public final class FileShareItems implements JsonSerializable<FileShareItems> {
    /*
     * List of file shares returned.
     */
    private List<FileShareItemInner> value;

    /*
     * Request URL that can be used to query next page of shares. Returned when total number of requested shares exceed
     * maximum page size.
     */
    private String nextLink;

    /**
     * Creates an instance of FileShareItems class.
     */
    public FileShareItems() {
    }

    /**
     * Get the value property: List of file shares returned.
     * 
     * @return the value value.
     */
    public List<FileShareItemInner> value() {
        return this.value;
    }

    /**
     * Get the nextLink property: Request URL that can be used to query next page of shares. Returned when total number
     * of requested shares exceed maximum page size.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FileShareItems from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FileShareItems if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the FileShareItems.
     */
    public static FileShareItems fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FileShareItems deserializedFileShareItems = new FileShareItems();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<FileShareItemInner> value = reader.readArray(reader1 -> FileShareItemInner.fromJson(reader1));
                    deserializedFileShareItems.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedFileShareItems.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedFileShareItems;
        });
    }
}
