// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Filters limit rule actions to a subset of blobs within the storage account. If multiple filters are defined, a
 * logical AND is performed on all filters.
 */
@Fluent
public final class ManagementPolicyFilter implements JsonSerializable<ManagementPolicyFilter> {
    /*
     * An array of strings for prefixes to be match.
     */
    private List<String> prefixMatch;

    /*
     * An array of predefined enum values. Currently blockBlob supports all tiering and delete actions. Only delete
     * actions are supported for appendBlob.
     */
    private List<String> blobTypes;

    /*
     * An array of blob index tag based filters, there can be at most 10 tag filters
     */
    private List<TagFilter> blobIndexMatch;

    /**
     * Creates an instance of ManagementPolicyFilter class.
     */
    public ManagementPolicyFilter() {
    }

    /**
     * Get the prefixMatch property: An array of strings for prefixes to be match.
     * 
     * @return the prefixMatch value.
     */
    public List<String> prefixMatch() {
        return this.prefixMatch;
    }

    /**
     * Set the prefixMatch property: An array of strings for prefixes to be match.
     * 
     * @param prefixMatch the prefixMatch value to set.
     * @return the ManagementPolicyFilter object itself.
     */
    public ManagementPolicyFilter withPrefixMatch(List<String> prefixMatch) {
        this.prefixMatch = prefixMatch;
        return this;
    }

    /**
     * Get the blobTypes property: An array of predefined enum values. Currently blockBlob supports all tiering and
     * delete actions. Only delete actions are supported for appendBlob.
     * 
     * @return the blobTypes value.
     */
    public List<String> blobTypes() {
        return this.blobTypes;
    }

    /**
     * Set the blobTypes property: An array of predefined enum values. Currently blockBlob supports all tiering and
     * delete actions. Only delete actions are supported for appendBlob.
     * 
     * @param blobTypes the blobTypes value to set.
     * @return the ManagementPolicyFilter object itself.
     */
    public ManagementPolicyFilter withBlobTypes(List<String> blobTypes) {
        this.blobTypes = blobTypes;
        return this;
    }

    /**
     * Get the blobIndexMatch property: An array of blob index tag based filters, there can be at most 10 tag filters.
     * 
     * @return the blobIndexMatch value.
     */
    public List<TagFilter> blobIndexMatch() {
        return this.blobIndexMatch;
    }

    /**
     * Set the blobIndexMatch property: An array of blob index tag based filters, there can be at most 10 tag filters.
     * 
     * @param blobIndexMatch the blobIndexMatch value to set.
     * @return the ManagementPolicyFilter object itself.
     */
    public ManagementPolicyFilter withBlobIndexMatch(List<TagFilter> blobIndexMatch) {
        this.blobIndexMatch = blobIndexMatch;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (blobTypes() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property blobTypes in model ManagementPolicyFilter"));
        }
        if (blobIndexMatch() != null) {
            blobIndexMatch().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ManagementPolicyFilter.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("blobTypes", this.blobTypes, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("prefixMatch", this.prefixMatch, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("blobIndexMatch", this.blobIndexMatch,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagementPolicyFilter from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagementPolicyFilter if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ManagementPolicyFilter.
     */
    public static ManagementPolicyFilter fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagementPolicyFilter deserializedManagementPolicyFilter = new ManagementPolicyFilter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("blobTypes".equals(fieldName)) {
                    List<String> blobTypes = reader.readArray(reader1 -> reader1.getString());
                    deserializedManagementPolicyFilter.blobTypes = blobTypes;
                } else if ("prefixMatch".equals(fieldName)) {
                    List<String> prefixMatch = reader.readArray(reader1 -> reader1.getString());
                    deserializedManagementPolicyFilter.prefixMatch = prefixMatch;
                } else if ("blobIndexMatch".equals(fieldName)) {
                    List<TagFilter> blobIndexMatch = reader.readArray(reader1 -> TagFilter.fromJson(reader1));
                    deserializedManagementPolicyFilter.blobIndexMatch = blobIndexMatch;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagementPolicyFilter;
        });
    }
}
