// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The replication policy rule between two containers.
 */
@Fluent
public final class ObjectReplicationPolicyRule implements JsonSerializable<ObjectReplicationPolicyRule> {
    /*
     * Rule Id is auto-generated for each new rule on destination account. It is required for put policy on source
     * account.
     */
    private String ruleId;

    /*
     * Required. Source container name.
     */
    private String sourceContainer;

    /*
     * Required. Destination container name.
     */
    private String destinationContainer;

    /*
     * Optional. An object that defines the filter set.
     */
    private ObjectReplicationPolicyFilter filters;

    /**
     * Creates an instance of ObjectReplicationPolicyRule class.
     */
    public ObjectReplicationPolicyRule() {
    }

    /**
     * Get the ruleId property: Rule Id is auto-generated for each new rule on destination account. It is required for
     * put policy on source account.
     * 
     * @return the ruleId value.
     */
    public String ruleId() {
        return this.ruleId;
    }

    /**
     * Set the ruleId property: Rule Id is auto-generated for each new rule on destination account. It is required for
     * put policy on source account.
     * 
     * @param ruleId the ruleId value to set.
     * @return the ObjectReplicationPolicyRule object itself.
     */
    public ObjectReplicationPolicyRule withRuleId(String ruleId) {
        this.ruleId = ruleId;
        return this;
    }

    /**
     * Get the sourceContainer property: Required. Source container name.
     * 
     * @return the sourceContainer value.
     */
    public String sourceContainer() {
        return this.sourceContainer;
    }

    /**
     * Set the sourceContainer property: Required. Source container name.
     * 
     * @param sourceContainer the sourceContainer value to set.
     * @return the ObjectReplicationPolicyRule object itself.
     */
    public ObjectReplicationPolicyRule withSourceContainer(String sourceContainer) {
        this.sourceContainer = sourceContainer;
        return this;
    }

    /**
     * Get the destinationContainer property: Required. Destination container name.
     * 
     * @return the destinationContainer value.
     */
    public String destinationContainer() {
        return this.destinationContainer;
    }

    /**
     * Set the destinationContainer property: Required. Destination container name.
     * 
     * @param destinationContainer the destinationContainer value to set.
     * @return the ObjectReplicationPolicyRule object itself.
     */
    public ObjectReplicationPolicyRule withDestinationContainer(String destinationContainer) {
        this.destinationContainer = destinationContainer;
        return this;
    }

    /**
     * Get the filters property: Optional. An object that defines the filter set.
     * 
     * @return the filters value.
     */
    public ObjectReplicationPolicyFilter filters() {
        return this.filters;
    }

    /**
     * Set the filters property: Optional. An object that defines the filter set.
     * 
     * @param filters the filters value to set.
     * @return the ObjectReplicationPolicyRule object itself.
     */
    public ObjectReplicationPolicyRule withFilters(ObjectReplicationPolicyFilter filters) {
        this.filters = filters;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (sourceContainer() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property sourceContainer in model ObjectReplicationPolicyRule"));
        }
        if (destinationContainer() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property destinationContainer in model ObjectReplicationPolicyRule"));
        }
        if (filters() != null) {
            filters().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ObjectReplicationPolicyRule.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("sourceContainer", this.sourceContainer);
        jsonWriter.writeStringField("destinationContainer", this.destinationContainer);
        jsonWriter.writeStringField("ruleId", this.ruleId);
        jsonWriter.writeJsonField("filters", this.filters);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ObjectReplicationPolicyRule from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ObjectReplicationPolicyRule if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ObjectReplicationPolicyRule.
     */
    public static ObjectReplicationPolicyRule fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ObjectReplicationPolicyRule deserializedObjectReplicationPolicyRule = new ObjectReplicationPolicyRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("sourceContainer".equals(fieldName)) {
                    deserializedObjectReplicationPolicyRule.sourceContainer = reader.getString();
                } else if ("destinationContainer".equals(fieldName)) {
                    deserializedObjectReplicationPolicyRule.destinationContainer = reader.getString();
                } else if ("ruleId".equals(fieldName)) {
                    deserializedObjectReplicationPolicyRule.ruleId = reader.getString();
                } else if ("filters".equals(fieldName)) {
                    deserializedObjectReplicationPolicyRule.filters = ObjectReplicationPolicyFilter.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedObjectReplicationPolicyRule;
        });
    }
}
