// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;

/**
 * An access key for the storage account.
 */
@Immutable
public final class StorageAccountKey implements JsonSerializable<StorageAccountKey> {
    /*
     * Name of the key.
     */
    private String keyName;

    /*
     * Base 64-encoded value of the key.
     */
    private String value;

    /*
     * Permissions for the key -- read-only or full permissions.
     */
    private KeyPermission permissions;

    /*
     * Creation time of the key, in round trip date format.
     */
    private OffsetDateTime creationTime;

    /**
     * Creates an instance of StorageAccountKey class.
     */
    public StorageAccountKey() {
    }

    /**
     * Get the keyName property: Name of the key.
     * 
     * @return the keyName value.
     */
    public String keyName() {
        return this.keyName;
    }

    /**
     * Get the value property: Base 64-encoded value of the key.
     * 
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Get the permissions property: Permissions for the key -- read-only or full permissions.
     * 
     * @return the permissions value.
     */
    public KeyPermission permissions() {
        return this.permissions;
    }

    /**
     * Get the creationTime property: Creation time of the key, in round trip date format.
     * 
     * @return the creationTime value.
     */
    public OffsetDateTime creationTime() {
        return this.creationTime;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of StorageAccountKey from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of StorageAccountKey if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the StorageAccountKey.
     */
    public static StorageAccountKey fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            StorageAccountKey deserializedStorageAccountKey = new StorageAccountKey();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("keyName".equals(fieldName)) {
                    deserializedStorageAccountKey.keyName = reader.getString();
                } else if ("value".equals(fieldName)) {
                    deserializedStorageAccountKey.value = reader.getString();
                } else if ("permissions".equals(fieldName)) {
                    deserializedStorageAccountKey.permissions = KeyPermission.fromString(reader.getString());
                } else if ("creationTime".equals(fieldName)) {
                    deserializedStorageAccountKey.creationTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedStorageAccountKey;
        });
    }
}
