// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The List SAS credentials operation response.
 */
@Immutable
public final class ListAccountSasResponseInner implements JsonSerializable<ListAccountSasResponseInner> {
    /*
     * List SAS credentials of storage account.
     */
    private String accountSasToken;

    /**
     * Creates an instance of ListAccountSasResponseInner class.
     */
    public ListAccountSasResponseInner() {
    }

    /**
     * Get the accountSasToken property: List SAS credentials of storage account.
     * 
     * @return the accountSasToken value.
     */
    public String accountSasToken() {
        return this.accountSasToken;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ListAccountSasResponseInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ListAccountSasResponseInner if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ListAccountSasResponseInner.
     */
    public static ListAccountSasResponseInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ListAccountSasResponseInner deserializedListAccountSasResponseInner = new ListAccountSasResponseInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("accountSasToken".equals(fieldName)) {
                    deserializedListAccountSasResponseInner.accountSasToken = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedListAccountSasResponseInner;
        });
    }
}
