// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Parameters of the storage task assignment update request.
 */
@Fluent
public final class StorageTaskAssignmentUpdateParameters
    implements JsonSerializable<StorageTaskAssignmentUpdateParameters> {
    /*
     * Properties of the storage task assignment.
     */
    private StorageTaskAssignmentUpdateProperties properties;

    /**
     * Creates an instance of StorageTaskAssignmentUpdateParameters class.
     */
    public StorageTaskAssignmentUpdateParameters() {
    }

    /**
     * Get the properties property: Properties of the storage task assignment.
     * 
     * @return the properties value.
     */
    public StorageTaskAssignmentUpdateProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties property: Properties of the storage task assignment.
     * 
     * @param properties the properties value to set.
     * @return the StorageTaskAssignmentUpdateParameters object itself.
     */
    public StorageTaskAssignmentUpdateParameters withProperties(StorageTaskAssignmentUpdateProperties properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (properties() != null) {
            properties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.properties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of StorageTaskAssignmentUpdateParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of StorageTaskAssignmentUpdateParameters if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the StorageTaskAssignmentUpdateParameters.
     */
    public static StorageTaskAssignmentUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            StorageTaskAssignmentUpdateParameters deserializedStorageTaskAssignmentUpdateParameters
                = new StorageTaskAssignmentUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("properties".equals(fieldName)) {
                    deserializedStorageTaskAssignmentUpdateParameters.properties
                        = StorageTaskAssignmentUpdateProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedStorageTaskAssignmentUpdateParameters;
        });
    }
}
