/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.fluent.models.EncryptionScopeProperties;
import com.azure.resourcemanager.storage.models.EncryptionScopeKeyVaultProperties;
import com.azure.resourcemanager.storage.models.EncryptionScopeSource;
import com.azure.resourcemanager.storage.models.EncryptionScopeState;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class EncryptionScopeInner
extends ProxyResource {
    private EncryptionScopeProperties innerEncryptionScopeProperties;
    private String id;
    private String name;
    private String type;

    private EncryptionScopeProperties innerEncryptionScopeProperties() {
        return this.innerEncryptionScopeProperties;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public EncryptionScopeSource source() {
        return this.innerEncryptionScopeProperties() == null ? null : this.innerEncryptionScopeProperties().source();
    }

    public EncryptionScopeInner withSource(EncryptionScopeSource source) {
        if (this.innerEncryptionScopeProperties() == null) {
            this.innerEncryptionScopeProperties = new EncryptionScopeProperties();
        }
        this.innerEncryptionScopeProperties().withSource(source);
        return this;
    }

    public EncryptionScopeState state() {
        return this.innerEncryptionScopeProperties() == null ? null : this.innerEncryptionScopeProperties().state();
    }

    public EncryptionScopeInner withState(EncryptionScopeState state) {
        if (this.innerEncryptionScopeProperties() == null) {
            this.innerEncryptionScopeProperties = new EncryptionScopeProperties();
        }
        this.innerEncryptionScopeProperties().withState(state);
        return this;
    }

    public OffsetDateTime creationTime() {
        return this.innerEncryptionScopeProperties() == null ? null : this.innerEncryptionScopeProperties().creationTime();
    }

    public OffsetDateTime lastModifiedTime() {
        return this.innerEncryptionScopeProperties() == null ? null : this.innerEncryptionScopeProperties().lastModifiedTime();
    }

    public EncryptionScopeKeyVaultProperties keyVaultProperties() {
        return this.innerEncryptionScopeProperties() == null ? null : this.innerEncryptionScopeProperties().keyVaultProperties();
    }

    public EncryptionScopeInner withKeyVaultProperties(EncryptionScopeKeyVaultProperties keyVaultProperties) {
        if (this.innerEncryptionScopeProperties() == null) {
            this.innerEncryptionScopeProperties = new EncryptionScopeProperties();
        }
        this.innerEncryptionScopeProperties().withKeyVaultProperties(keyVaultProperties);
        return this;
    }

    public Boolean requireInfrastructureEncryption() {
        return this.innerEncryptionScopeProperties() == null ? null : this.innerEncryptionScopeProperties().requireInfrastructureEncryption();
    }

    public EncryptionScopeInner withRequireInfrastructureEncryption(Boolean requireInfrastructureEncryption) {
        if (this.innerEncryptionScopeProperties() == null) {
            this.innerEncryptionScopeProperties = new EncryptionScopeProperties();
        }
        this.innerEncryptionScopeProperties().withRequireInfrastructureEncryption(requireInfrastructureEncryption);
        return this;
    }

    public void validate() {
        if (this.innerEncryptionScopeProperties() != null) {
            this.innerEncryptionScopeProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerEncryptionScopeProperties);
        return jsonWriter.writeEndObject();
    }

    public static EncryptionScopeInner fromJson(JsonReader jsonReader) throws IOException {
        return (EncryptionScopeInner)((Object)jsonReader.readObject(reader -> {
            EncryptionScopeInner deserializedEncryptionScopeInner = new EncryptionScopeInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedEncryptionScopeInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedEncryptionScopeInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedEncryptionScopeInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedEncryptionScopeInner.innerEncryptionScopeProperties = EncryptionScopeProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEncryptionScopeInner;
        }));
    }
}

