/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class KeyCreationTime
implements JsonSerializable<KeyCreationTime> {
    private OffsetDateTime key1;
    private OffsetDateTime key2;

    public OffsetDateTime key1() {
        return this.key1;
    }

    public KeyCreationTime withKey1(OffsetDateTime key1) {
        this.key1 = key1;
        return this;
    }

    public OffsetDateTime key2() {
        return this.key2;
    }

    public KeyCreationTime withKey2(OffsetDateTime key2) {
        this.key2 = key2;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("key1", this.key1 == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.key1));
        jsonWriter.writeStringField("key2", this.key2 == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.key2));
        return jsonWriter.writeEndObject();
    }

    public static KeyCreationTime fromJson(JsonReader jsonReader) throws IOException {
        return (KeyCreationTime)jsonReader.readObject(reader -> {
            KeyCreationTime deserializedKeyCreationTime = new KeyCreationTime();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("key1".equals(fieldName)) {
                    deserializedKeyCreationTime.key1 = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("key2".equals(fieldName)) {
                    deserializedKeyCreationTime.key2 = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKeyCreationTime;
        });
    }
}

