/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class StorageAccountCheckNameAvailabilityParameters
implements JsonSerializable<StorageAccountCheckNameAvailabilityParameters> {
    private String name;
    private String type = "Microsoft.Storage/storageAccounts";
    private static final ClientLogger LOGGER = new ClientLogger(StorageAccountCheckNameAvailabilityParameters.class);

    public String name() {
        return this.name;
    }

    public StorageAccountCheckNameAvailabilityParameters withName(String name) {
        this.name = name;
        return this;
    }

    public String type() {
        return this.type;
    }

    public StorageAccountCheckNameAvailabilityParameters withType(String type) {
        this.type = type;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model StorageAccountCheckNameAvailabilityParameters"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    public static StorageAccountCheckNameAvailabilityParameters fromJson(JsonReader jsonReader) throws IOException {
        return (StorageAccountCheckNameAvailabilityParameters)jsonReader.readObject(reader -> {
            StorageAccountCheckNameAvailabilityParameters deserializedStorageAccountCheckNameAvailabilityParameters = new StorageAccountCheckNameAvailabilityParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedStorageAccountCheckNameAvailabilityParameters.name = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStorageAccountCheckNameAvailabilityParameters;
        });
    }
}

