// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.storage.fluent.models.ListTableServicesInner;
import com.azure.resourcemanager.storage.fluent.models.TableServicePropertiesInner;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in TableServicesClient.
 */
public interface TableServicesClient {
    /**
     * List all table services for the storage account.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     * insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ListTableServicesInner>> listWithResponseAsync(String resourceGroupName, String accountName);

    /**
     * List all table services for the storage account.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     * insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ListTableServicesInner> listAsync(String resourceGroupName, String accountName);

    /**
     * List all table services for the storage account.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     * insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ListTableServicesInner> listWithResponse(String resourceGroupName, String accountName, Context context);

    /**
     * List all table services for the storage account.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     * insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ListTableServicesInner list(String resourceGroupName, String accountName);

    /**
     * Sets the properties of a storage account’s Table service, including properties for Storage Analytics and CORS
     * (Cross-Origin Resource Sharing) rules.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     * insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param parameters The properties of a storage account’s Table service, only properties for Storage Analytics and
     * CORS (Cross-Origin Resource Sharing) rules can be specified.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the properties of a storage account’s Table service along with {@link Response} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<TableServicePropertiesInner>> setServicePropertiesWithResponseAsync(String resourceGroupName,
        String accountName, TableServicePropertiesInner parameters);

    /**
     * Sets the properties of a storage account’s Table service, including properties for Storage Analytics and CORS
     * (Cross-Origin Resource Sharing) rules.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     * insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param parameters The properties of a storage account’s Table service, only properties for Storage Analytics and
     * CORS (Cross-Origin Resource Sharing) rules can be specified.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the properties of a storage account’s Table service on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<TableServicePropertiesInner> setServicePropertiesAsync(String resourceGroupName, String accountName,
        TableServicePropertiesInner parameters);

    /**
     * Sets the properties of a storage account’s Table service, including properties for Storage Analytics and CORS
     * (Cross-Origin Resource Sharing) rules.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     * insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param parameters The properties of a storage account’s Table service, only properties for Storage Analytics and
     * CORS (Cross-Origin Resource Sharing) rules can be specified.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the properties of a storage account’s Table service along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<TableServicePropertiesInner> setServicePropertiesWithResponse(String resourceGroupName, String accountName,
        TableServicePropertiesInner parameters, Context context);

    /**
     * Sets the properties of a storage account’s Table service, including properties for Storage Analytics and CORS
     * (Cross-Origin Resource Sharing) rules.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     * insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param parameters The properties of a storage account’s Table service, only properties for Storage Analytics and
     * CORS (Cross-Origin Resource Sharing) rules can be specified.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the properties of a storage account’s Table service.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    TableServicePropertiesInner setServiceProperties(String resourceGroupName, String accountName,
        TableServicePropertiesInner parameters);

    /**
     * Gets the properties of a storage account’s Table service, including properties for Storage Analytics and CORS
     * (Cross-Origin Resource Sharing) rules.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     * insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the properties of a storage account’s Table service, including properties for Storage Analytics and CORS
     * (Cross-Origin Resource Sharing) rules along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<TableServicePropertiesInner>> getServicePropertiesWithResponseAsync(String resourceGroupName,
        String accountName);

    /**
     * Gets the properties of a storage account’s Table service, including properties for Storage Analytics and CORS
     * (Cross-Origin Resource Sharing) rules.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     * insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the properties of a storage account’s Table service, including properties for Storage Analytics and CORS
     * (Cross-Origin Resource Sharing) rules on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<TableServicePropertiesInner> getServicePropertiesAsync(String resourceGroupName, String accountName);

    /**
     * Gets the properties of a storage account’s Table service, including properties for Storage Analytics and CORS
     * (Cross-Origin Resource Sharing) rules.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     * insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the properties of a storage account’s Table service, including properties for Storage Analytics and CORS
     * (Cross-Origin Resource Sharing) rules along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<TableServicePropertiesInner> getServicePropertiesWithResponse(String resourceGroupName, String accountName,
        Context context);

    /**
     * Gets the properties of a storage account’s Table service, including properties for Storage Analytics and CORS
     * (Cross-Origin Resource Sharing) rules.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     * insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     * must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the properties of a storage account’s Table service, including properties for Storage Analytics and CORS
     * (Cross-Origin Resource Sharing) rules.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    TableServicePropertiesInner getServiceProperties(String resourceGroupName, String accountName);
}
