// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Deleted storage account.
 */
@Immutable
public final class DeletedAccountInner extends ProxyResource {
    /*
     * Properties of the deleted account.
     */
    private DeletedAccountProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of DeletedAccountInner class.
     */
    public DeletedAccountInner() {
    }

    /**
     * Get the innerProperties property: Properties of the deleted account.
     * 
     * @return the innerProperties value.
     */
    private DeletedAccountProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the storageAccountResourceId property: Full resource id of the original storage account.
     * 
     * @return the storageAccountResourceId value.
     */
    public String storageAccountResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().storageAccountResourceId();
    }

    /**
     * Get the location property: Location of the deleted account.
     * 
     * @return the location value.
     */
    public String location() {
        return this.innerProperties() == null ? null : this.innerProperties().location();
    }

    /**
     * Get the restoreReference property: Can be used to attempt recovering this deleted account via PutStorageAccount
     * API.
     * 
     * @return the restoreReference value.
     */
    public String restoreReference() {
        return this.innerProperties() == null ? null : this.innerProperties().restoreReference();
    }

    /**
     * Get the creationTime property: Creation time of the deleted account.
     * 
     * @return the creationTime value.
     */
    public String creationTime() {
        return this.innerProperties() == null ? null : this.innerProperties().creationTime();
    }

    /**
     * Get the deletionTime property: Deletion time of the deleted account.
     * 
     * @return the deletionTime value.
     */
    public String deletionTime() {
        return this.innerProperties() == null ? null : this.innerProperties().deletionTime();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DeletedAccountInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DeletedAccountInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DeletedAccountInner.
     */
    public static DeletedAccountInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DeletedAccountInner deserializedDeletedAccountInner = new DeletedAccountInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedDeletedAccountInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedDeletedAccountInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedDeletedAccountInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedDeletedAccountInner.innerProperties = DeletedAccountProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDeletedAccountInner;
        });
    }
}
