// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * The StorageQueue model.
 */
@Fluent
public final class StorageQueueInner extends ProxyResource {
    /*
     * Queue resource properties.
     */
    private QueueProperties innerQueueProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of StorageQueueInner class.
     */
    public StorageQueueInner() {
    }

    /**
     * Get the innerQueueProperties property: Queue resource properties.
     * 
     * @return the innerQueueProperties value.
     */
    private QueueProperties innerQueueProperties() {
        return this.innerQueueProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the metadata property: A name-value pair that represents queue metadata.
     * 
     * @return the metadata value.
     */
    public Map<String, String> metadata() {
        return this.innerQueueProperties() == null ? null : this.innerQueueProperties().metadata();
    }

    /**
     * Set the metadata property: A name-value pair that represents queue metadata.
     * 
     * @param metadata the metadata value to set.
     * @return the StorageQueueInner object itself.
     */
    public StorageQueueInner withMetadata(Map<String, String> metadata) {
        if (this.innerQueueProperties() == null) {
            this.innerQueueProperties = new QueueProperties();
        }
        this.innerQueueProperties().withMetadata(metadata);
        return this;
    }

    /**
     * Get the approximateMessageCount property: Integer indicating an approximate number of messages in the queue. This
     * number is not lower than the actual number of messages in the queue, but could be higher.
     * 
     * @return the approximateMessageCount value.
     */
    public Integer approximateMessageCount() {
        return this.innerQueueProperties() == null ? null : this.innerQueueProperties().approximateMessageCount();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerQueueProperties() != null) {
            innerQueueProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerQueueProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of StorageQueueInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of StorageQueueInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the StorageQueueInner.
     */
    public static StorageQueueInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            StorageQueueInner deserializedStorageQueueInner = new StorageQueueInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedStorageQueueInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedStorageQueueInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedStorageQueueInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedStorageQueueInner.innerQueueProperties = QueueProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedStorageQueueInner;
        });
    }
}
