// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.fluent.models.EncryptionScopeInner;
import java.io.IOException;
import java.util.List;

/**
 * List of encryption scopes requested, and if paging is required, a URL to the next page of encryption scopes.
 */
@Immutable
public final class EncryptionScopeListResult implements JsonSerializable<EncryptionScopeListResult> {
    /*
     * List of encryption scopes requested.
     */
    private List<EncryptionScopeInner> value;

    /*
     * Request URL that can be used to query next page of encryption scopes. Returned when total number of requested
     * encryption scopes exceeds the maximum page size.
     */
    private String nextLink;

    /**
     * Creates an instance of EncryptionScopeListResult class.
     */
    public EncryptionScopeListResult() {
    }

    /**
     * Get the value property: List of encryption scopes requested.
     * 
     * @return the value value.
     */
    public List<EncryptionScopeInner> value() {
        return this.value;
    }

    /**
     * Get the nextLink property: Request URL that can be used to query next page of encryption scopes. Returned when
     * total number of requested encryption scopes exceeds the maximum page size.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of EncryptionScopeListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of EncryptionScopeListResult if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the EncryptionScopeListResult.
     */
    public static EncryptionScopeListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            EncryptionScopeListResult deserializedEncryptionScopeListResult = new EncryptionScopeListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<EncryptionScopeInner> value
                        = reader.readArray(reader1 -> EncryptionScopeInner.fromJson(reader1));
                    deserializedEncryptionScopeListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedEncryptionScopeListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedEncryptionScopeListResult;
        });
    }
}
