// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.rest.ResponseBase;
import com.azure.resourcemanager.storage.fluent.models.LeaseShareResponseInner;

/**
 * Contains all response data for the lease operation.
 */
public final class FileSharesLeaseResponse extends ResponseBase<FileSharesLeaseHeaders, LeaseShareResponseInner> {
    /**
     * Creates an instance of FileSharesLeaseResponse.
     * 
     * @param request the request which resulted in this FileSharesLeaseResponse.
     * @param statusCode the status code of the HTTP response.
     * @param rawHeaders the raw headers of the HTTP response.
     * @param value the deserialized value of the HTTP response.
     * @param headers the deserialized headers of the HTTP response.
     */
    public FileSharesLeaseResponse(HttpRequest request, int statusCode, HttpHeaders rawHeaders,
        LeaseShareResponseInner value, FileSharesLeaseHeaders headers) {
        super(request, statusCode, rawHeaders, value, headers);
    }

    /**
     * Gets the deserialized response body.
     * 
     * @return the deserialized response body.
     */
    @Override
    public LeaseShareResponseInner getValue() {
        return super.getValue();
    }
}
