// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Attributes of a deleted storage account.
 */
@Immutable
public final class DeletedAccountProperties implements JsonSerializable<DeletedAccountProperties> {
    /*
     * Full resource id of the original storage account.
     */
    private String storageAccountResourceId;

    /*
     * Location of the deleted account.
     */
    private String location;

    /*
     * Can be used to attempt recovering this deleted account via PutStorageAccount API.
     */
    private String restoreReference;

    /*
     * Creation time of the deleted account.
     */
    private String creationTime;

    /*
     * Deletion time of the deleted account.
     */
    private String deletionTime;

    /**
     * Creates an instance of DeletedAccountProperties class.
     */
    public DeletedAccountProperties() {
    }

    /**
     * Get the storageAccountResourceId property: Full resource id of the original storage account.
     * 
     * @return the storageAccountResourceId value.
     */
    public String storageAccountResourceId() {
        return this.storageAccountResourceId;
    }

    /**
     * Get the location property: Location of the deleted account.
     * 
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Get the restoreReference property: Can be used to attempt recovering this deleted account via PutStorageAccount
     * API.
     * 
     * @return the restoreReference value.
     */
    public String restoreReference() {
        return this.restoreReference;
    }

    /**
     * Get the creationTime property: Creation time of the deleted account.
     * 
     * @return the creationTime value.
     */
    public String creationTime() {
        return this.creationTime;
    }

    /**
     * Get the deletionTime property: Deletion time of the deleted account.
     * 
     * @return the deletionTime value.
     */
    public String deletionTime() {
        return this.deletionTime;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DeletedAccountProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DeletedAccountProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DeletedAccountProperties.
     */
    public static DeletedAccountProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DeletedAccountProperties deserializedDeletedAccountProperties = new DeletedAccountProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("storageAccountResourceId".equals(fieldName)) {
                    deserializedDeletedAccountProperties.storageAccountResourceId = reader.getString();
                } else if ("location".equals(fieldName)) {
                    deserializedDeletedAccountProperties.location = reader.getString();
                } else if ("restoreReference".equals(fieldName)) {
                    deserializedDeletedAccountProperties.restoreReference = reader.getString();
                } else if ("creationTime".equals(fieldName)) {
                    deserializedDeletedAccountProperties.creationTime = reader.getString();
                } else if ("deletionTime".equals(fieldName)) {
                    deserializedDeletedAccountProperties.deletionTime = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDeletedAccountProperties;
        });
    }
}
