// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.models.ImmutabilityPolicyState;
import java.io.IOException;

/**
 * The properties of an ImmutabilityPolicy of a blob container.
 */
@Fluent
public final class ImmutabilityPolicyProperty implements JsonSerializable<ImmutabilityPolicyProperty> {
    /*
     * The immutability period for the blobs in the container since the policy creation, in days.
     */
    private Integer immutabilityPeriodSinceCreationInDays;

    /*
     * The ImmutabilityPolicy state of a blob container, possible values include: Locked and Unlocked.
     */
    private ImmutabilityPolicyState state;

    /*
     * This property can only be changed for unlocked time-based retention policies. When enabled, new blocks can be
     * written to an append blob while maintaining immutability protection and compliance. Only new blocks can be added
     * and any existing blocks cannot be modified or deleted. This property cannot be changed with
     * ExtendImmutabilityPolicy API.
     */
    private Boolean allowProtectedAppendWrites;

    /*
     * This property can only be changed for unlocked time-based retention policies. When enabled, new blocks can be
     * written to both 'Append and Bock Blobs' while maintaining immutability protection and compliance. Only new blocks
     * can be added and any existing blocks cannot be modified or deleted. This property cannot be changed with
     * ExtendImmutabilityPolicy API. The 'allowProtectedAppendWrites' and 'allowProtectedAppendWritesAll' properties are
     * mutually exclusive.
     */
    private Boolean allowProtectedAppendWritesAll;

    /**
     * Creates an instance of ImmutabilityPolicyProperty class.
     */
    public ImmutabilityPolicyProperty() {
    }

    /**
     * Get the immutabilityPeriodSinceCreationInDays property: The immutability period for the blobs in the container
     * since the policy creation, in days.
     * 
     * @return the immutabilityPeriodSinceCreationInDays value.
     */
    public Integer immutabilityPeriodSinceCreationInDays() {
        return this.immutabilityPeriodSinceCreationInDays;
    }

    /**
     * Set the immutabilityPeriodSinceCreationInDays property: The immutability period for the blobs in the container
     * since the policy creation, in days.
     * 
     * @param immutabilityPeriodSinceCreationInDays the immutabilityPeriodSinceCreationInDays value to set.
     * @return the ImmutabilityPolicyProperty object itself.
     */
    public ImmutabilityPolicyProperty
        withImmutabilityPeriodSinceCreationInDays(Integer immutabilityPeriodSinceCreationInDays) {
        this.immutabilityPeriodSinceCreationInDays = immutabilityPeriodSinceCreationInDays;
        return this;
    }

    /**
     * Get the state property: The ImmutabilityPolicy state of a blob container, possible values include: Locked and
     * Unlocked.
     * 
     * @return the state value.
     */
    public ImmutabilityPolicyState state() {
        return this.state;
    }

    /**
     * Get the allowProtectedAppendWrites property: This property can only be changed for unlocked time-based retention
     * policies. When enabled, new blocks can be written to an append blob while maintaining immutability protection and
     * compliance. Only new blocks can be added and any existing blocks cannot be modified or deleted. This property
     * cannot be changed with ExtendImmutabilityPolicy API.
     * 
     * @return the allowProtectedAppendWrites value.
     */
    public Boolean allowProtectedAppendWrites() {
        return this.allowProtectedAppendWrites;
    }

    /**
     * Set the allowProtectedAppendWrites property: This property can only be changed for unlocked time-based retention
     * policies. When enabled, new blocks can be written to an append blob while maintaining immutability protection and
     * compliance. Only new blocks can be added and any existing blocks cannot be modified or deleted. This property
     * cannot be changed with ExtendImmutabilityPolicy API.
     * 
     * @param allowProtectedAppendWrites the allowProtectedAppendWrites value to set.
     * @return the ImmutabilityPolicyProperty object itself.
     */
    public ImmutabilityPolicyProperty withAllowProtectedAppendWrites(Boolean allowProtectedAppendWrites) {
        this.allowProtectedAppendWrites = allowProtectedAppendWrites;
        return this;
    }

    /**
     * Get the allowProtectedAppendWritesAll property: This property can only be changed for unlocked time-based
     * retention policies. When enabled, new blocks can be written to both 'Append and Bock Blobs' while maintaining
     * immutability protection and compliance. Only new blocks can be added and any existing blocks cannot be modified
     * or deleted. This property cannot be changed with ExtendImmutabilityPolicy API. The 'allowProtectedAppendWrites'
     * and 'allowProtectedAppendWritesAll' properties are mutually exclusive.
     * 
     * @return the allowProtectedAppendWritesAll value.
     */
    public Boolean allowProtectedAppendWritesAll() {
        return this.allowProtectedAppendWritesAll;
    }

    /**
     * Set the allowProtectedAppendWritesAll property: This property can only be changed for unlocked time-based
     * retention policies. When enabled, new blocks can be written to both 'Append and Bock Blobs' while maintaining
     * immutability protection and compliance. Only new blocks can be added and any existing blocks cannot be modified
     * or deleted. This property cannot be changed with ExtendImmutabilityPolicy API. The 'allowProtectedAppendWrites'
     * and 'allowProtectedAppendWritesAll' properties are mutually exclusive.
     * 
     * @param allowProtectedAppendWritesAll the allowProtectedAppendWritesAll value to set.
     * @return the ImmutabilityPolicyProperty object itself.
     */
    public ImmutabilityPolicyProperty withAllowProtectedAppendWritesAll(Boolean allowProtectedAppendWritesAll) {
        this.allowProtectedAppendWritesAll = allowProtectedAppendWritesAll;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("immutabilityPeriodSinceCreationInDays",
            this.immutabilityPeriodSinceCreationInDays);
        jsonWriter.writeBooleanField("allowProtectedAppendWrites", this.allowProtectedAppendWrites);
        jsonWriter.writeBooleanField("allowProtectedAppendWritesAll", this.allowProtectedAppendWritesAll);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ImmutabilityPolicyProperty from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ImmutabilityPolicyProperty if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ImmutabilityPolicyProperty.
     */
    public static ImmutabilityPolicyProperty fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ImmutabilityPolicyProperty deserializedImmutabilityPolicyProperty = new ImmutabilityPolicyProperty();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("immutabilityPeriodSinceCreationInDays".equals(fieldName)) {
                    deserializedImmutabilityPolicyProperty.immutabilityPeriodSinceCreationInDays
                        = reader.getNullable(JsonReader::getInt);
                } else if ("state".equals(fieldName)) {
                    deserializedImmutabilityPolicyProperty.state
                        = ImmutabilityPolicyState.fromString(reader.getString());
                } else if ("allowProtectedAppendWrites".equals(fieldName)) {
                    deserializedImmutabilityPolicyProperty.allowProtectedAppendWrites
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("allowProtectedAppendWritesAll".equals(fieldName)) {
                    deserializedImmutabilityPolicyProperty.allowProtectedAppendWritesAll
                        = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedImmutabilityPolicyProperty;
        });
    }
}
