// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Lease Share response schema.
 */
@Fluent
public final class LeaseShareResponseInner implements JsonSerializable<LeaseShareResponseInner> {
    /*
     * Returned unique lease ID that must be included with any request to delete the share, or to renew, change, or
     * release the lease.
     */
    private String leaseId;

    /*
     * Approximate time remaining in the lease period, in seconds.
     */
    private String leaseTimeSeconds;

    /**
     * Creates an instance of LeaseShareResponseInner class.
     */
    public LeaseShareResponseInner() {
    }

    /**
     * Get the leaseId property: Returned unique lease ID that must be included with any request to delete the share, or
     * to renew, change, or release the lease.
     * 
     * @return the leaseId value.
     */
    public String leaseId() {
        return this.leaseId;
    }

    /**
     * Set the leaseId property: Returned unique lease ID that must be included with any request to delete the share, or
     * to renew, change, or release the lease.
     * 
     * @param leaseId the leaseId value to set.
     * @return the LeaseShareResponseInner object itself.
     */
    public LeaseShareResponseInner withLeaseId(String leaseId) {
        this.leaseId = leaseId;
        return this;
    }

    /**
     * Get the leaseTimeSeconds property: Approximate time remaining in the lease period, in seconds.
     * 
     * @return the leaseTimeSeconds value.
     */
    public String leaseTimeSeconds() {
        return this.leaseTimeSeconds;
    }

    /**
     * Set the leaseTimeSeconds property: Approximate time remaining in the lease period, in seconds.
     * 
     * @param leaseTimeSeconds the leaseTimeSeconds value to set.
     * @return the LeaseShareResponseInner object itself.
     */
    public LeaseShareResponseInner withLeaseTimeSeconds(String leaseTimeSeconds) {
        this.leaseTimeSeconds = leaseTimeSeconds;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("leaseId", this.leaseId);
        jsonWriter.writeStringField("leaseTimeSeconds", this.leaseTimeSeconds);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of LeaseShareResponseInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of LeaseShareResponseInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the LeaseShareResponseInner.
     */
    public static LeaseShareResponseInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            LeaseShareResponseInner deserializedLeaseShareResponseInner = new LeaseShareResponseInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("leaseId".equals(fieldName)) {
                    deserializedLeaseShareResponseInner.leaseId = reader.getString();
                } else if ("leaseTimeSeconds".equals(fieldName)) {
                    deserializedLeaseShareResponseInner.leaseTimeSeconds = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedLeaseShareResponseInner;
        });
    }
}
