// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The ListQueueServices model.
 */
@Immutable
public final class ListQueueServicesInner implements JsonSerializable<ListQueueServicesInner> {
    /*
     * List of queue services returned.
     */
    private List<QueueServicePropertiesInner> value;

    /**
     * Creates an instance of ListQueueServicesInner class.
     */
    public ListQueueServicesInner() {
    }

    /**
     * Get the value property: List of queue services returned.
     * 
     * @return the value value.
     */
    public List<QueueServicePropertiesInner> value() {
        return this.value;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ListQueueServicesInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ListQueueServicesInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ListQueueServicesInner.
     */
    public static ListQueueServicesInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ListQueueServicesInner deserializedListQueueServicesInner = new ListQueueServicesInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<QueueServicePropertiesInner> value
                        = reader.readArray(reader1 -> QueueServicePropertiesInner.fromJson(reader1));
                    deserializedListQueueServicesInner.value = value;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedListQueueServicesInner;
        });
    }
}
