// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.models.SshPublicKey;
import java.io.IOException;
import java.util.List;

/**
 * The Storage Account Local User keys.
 */
@Fluent
public final class LocalUserKeysInner implements JsonSerializable<LocalUserKeysInner> {
    /*
     * Optional, local user ssh authorized keys for SFTP.
     */
    private List<SshPublicKey> sshAuthorizedKeys;

    /*
     * Auto generated by the server for SMB authentication.
     */
    private String sharedKey;

    /**
     * Creates an instance of LocalUserKeysInner class.
     */
    public LocalUserKeysInner() {
    }

    /**
     * Get the sshAuthorizedKeys property: Optional, local user ssh authorized keys for SFTP.
     * 
     * @return the sshAuthorizedKeys value.
     */
    public List<SshPublicKey> sshAuthorizedKeys() {
        return this.sshAuthorizedKeys;
    }

    /**
     * Set the sshAuthorizedKeys property: Optional, local user ssh authorized keys for SFTP.
     * 
     * @param sshAuthorizedKeys the sshAuthorizedKeys value to set.
     * @return the LocalUserKeysInner object itself.
     */
    public LocalUserKeysInner withSshAuthorizedKeys(List<SshPublicKey> sshAuthorizedKeys) {
        this.sshAuthorizedKeys = sshAuthorizedKeys;
        return this;
    }

    /**
     * Get the sharedKey property: Auto generated by the server for SMB authentication.
     * 
     * @return the sharedKey value.
     */
    public String sharedKey() {
        return this.sharedKey;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (sshAuthorizedKeys() != null) {
            sshAuthorizedKeys().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("sshAuthorizedKeys", this.sshAuthorizedKeys,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of LocalUserKeysInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of LocalUserKeysInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the LocalUserKeysInner.
     */
    public static LocalUserKeysInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            LocalUserKeysInner deserializedLocalUserKeysInner = new LocalUserKeysInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("sshAuthorizedKeys".equals(fieldName)) {
                    List<SshPublicKey> sshAuthorizedKeys = reader.readArray(reader1 -> SshPublicKey.fromJson(reader1));
                    deserializedLocalUserKeysInner.sshAuthorizedKeys = sshAuthorizedKeys;
                } else if ("sharedKey".equals(fieldName)) {
                    deserializedLocalUserKeysInner.sharedKey = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedLocalUserKeysInner;
        });
    }
}
