// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * This property defines the creation time based filtering condition. Blob Inventory schema parameter 'Creation-Time' is
 * mandatory with this filter.
 */
@Fluent
public final class BlobInventoryCreationTime implements JsonSerializable<BlobInventoryCreationTime> {
    /*
     * When set the policy filters the objects that are created in the last N days. Where N is an integer value between
     * 1 to 36500.
     */
    private Integer lastNDays;

    /**
     * Creates an instance of BlobInventoryCreationTime class.
     */
    public BlobInventoryCreationTime() {
    }

    /**
     * Get the lastNDays property: When set the policy filters the objects that are created in the last N days. Where N
     * is an integer value between 1 to 36500.
     * 
     * @return the lastNDays value.
     */
    public Integer lastNDays() {
        return this.lastNDays;
    }

    /**
     * Set the lastNDays property: When set the policy filters the objects that are created in the last N days. Where N
     * is an integer value between 1 to 36500.
     * 
     * @param lastNDays the lastNDays value to set.
     * @return the BlobInventoryCreationTime object itself.
     */
    public BlobInventoryCreationTime withLastNDays(Integer lastNDays) {
        this.lastNDays = lastNDays;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("lastNDays", this.lastNDays);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BlobInventoryCreationTime from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BlobInventoryCreationTime if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the BlobInventoryCreationTime.
     */
    public static BlobInventoryCreationTime fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BlobInventoryCreationTime deserializedBlobInventoryCreationTime = new BlobInventoryCreationTime();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("lastNDays".equals(fieldName)) {
                    deserializedBlobInventoryCreationTime.lastNDays = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBlobInventoryCreationTime;
        });
    }
}
