// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

/**
 * Blob restore parameters.
 */
@Fluent
public final class BlobRestoreParameters implements JsonSerializable<BlobRestoreParameters> {
    /*
     * Restore blob to the specified time.
     */
    private OffsetDateTime timeToRestore;

    /*
     * Blob ranges to restore.
     */
    private List<BlobRestoreRange> blobRanges;

    /**
     * Creates an instance of BlobRestoreParameters class.
     */
    public BlobRestoreParameters() {
    }

    /**
     * Get the timeToRestore property: Restore blob to the specified time.
     * 
     * @return the timeToRestore value.
     */
    public OffsetDateTime timeToRestore() {
        return this.timeToRestore;
    }

    /**
     * Set the timeToRestore property: Restore blob to the specified time.
     * 
     * @param timeToRestore the timeToRestore value to set.
     * @return the BlobRestoreParameters object itself.
     */
    public BlobRestoreParameters withTimeToRestore(OffsetDateTime timeToRestore) {
        this.timeToRestore = timeToRestore;
        return this;
    }

    /**
     * Get the blobRanges property: Blob ranges to restore.
     * 
     * @return the blobRanges value.
     */
    public List<BlobRestoreRange> blobRanges() {
        return this.blobRanges;
    }

    /**
     * Set the blobRanges property: Blob ranges to restore.
     * 
     * @param blobRanges the blobRanges value to set.
     * @return the BlobRestoreParameters object itself.
     */
    public BlobRestoreParameters withBlobRanges(List<BlobRestoreRange> blobRanges) {
        this.blobRanges = blobRanges;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (timeToRestore() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property timeToRestore in model BlobRestoreParameters"));
        }
        if (blobRanges() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property blobRanges in model BlobRestoreParameters"));
        } else {
            blobRanges().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(BlobRestoreParameters.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("timeToRestore",
            this.timeToRestore == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.timeToRestore));
        jsonWriter.writeArrayField("blobRanges", this.blobRanges, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BlobRestoreParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BlobRestoreParameters if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the BlobRestoreParameters.
     */
    public static BlobRestoreParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BlobRestoreParameters deserializedBlobRestoreParameters = new BlobRestoreParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("timeToRestore".equals(fieldName)) {
                    deserializedBlobRestoreParameters.timeToRestore = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("blobRanges".equals(fieldName)) {
                    List<BlobRestoreRange> blobRanges = reader.readArray(reader1 -> BlobRestoreRange.fromJson(reader1));
                    deserializedBlobRestoreParameters.blobRanges = blobRanges;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBlobRestoreParameters;
        });
    }
}
