// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The encryption settings on the storage account.
 */
@Fluent
public final class Encryption implements JsonSerializable<Encryption> {
    /*
     * List of services which support encryption.
     */
    private EncryptionServices services;

    /*
     * The encryption keySource (provider). Possible values (case-insensitive): Microsoft.Storage, Microsoft.Keyvault
     */
    private KeySource keySource;

    /*
     * A boolean indicating whether or not the service applies a secondary layer of encryption with platform managed
     * keys for data at rest.
     */
    private Boolean requireInfrastructureEncryption;

    /*
     * Properties provided by key vault.
     */
    private KeyVaultProperties keyVaultProperties;

    /*
     * The identity to be used with service-side encryption at rest.
     */
    private EncryptionIdentity encryptionIdentity;

    /**
     * Creates an instance of Encryption class.
     */
    public Encryption() {
    }

    /**
     * Get the services property: List of services which support encryption.
     * 
     * @return the services value.
     */
    public EncryptionServices services() {
        return this.services;
    }

    /**
     * Set the services property: List of services which support encryption.
     * 
     * @param services the services value to set.
     * @return the Encryption object itself.
     */
    public Encryption withServices(EncryptionServices services) {
        this.services = services;
        return this;
    }

    /**
     * Get the keySource property: The encryption keySource (provider). Possible values (case-insensitive):
     * Microsoft.Storage, Microsoft.Keyvault.
     * 
     * @return the keySource value.
     */
    public KeySource keySource() {
        return this.keySource;
    }

    /**
     * Set the keySource property: The encryption keySource (provider). Possible values (case-insensitive):
     * Microsoft.Storage, Microsoft.Keyvault.
     * 
     * @param keySource the keySource value to set.
     * @return the Encryption object itself.
     */
    public Encryption withKeySource(KeySource keySource) {
        this.keySource = keySource;
        return this;
    }

    /**
     * Get the requireInfrastructureEncryption property: A boolean indicating whether or not the service applies a
     * secondary layer of encryption with platform managed keys for data at rest.
     * 
     * @return the requireInfrastructureEncryption value.
     */
    public Boolean requireInfrastructureEncryption() {
        return this.requireInfrastructureEncryption;
    }

    /**
     * Set the requireInfrastructureEncryption property: A boolean indicating whether or not the service applies a
     * secondary layer of encryption with platform managed keys for data at rest.
     * 
     * @param requireInfrastructureEncryption the requireInfrastructureEncryption value to set.
     * @return the Encryption object itself.
     */
    public Encryption withRequireInfrastructureEncryption(Boolean requireInfrastructureEncryption) {
        this.requireInfrastructureEncryption = requireInfrastructureEncryption;
        return this;
    }

    /**
     * Get the keyVaultProperties property: Properties provided by key vault.
     * 
     * @return the keyVaultProperties value.
     */
    public KeyVaultProperties keyVaultProperties() {
        return this.keyVaultProperties;
    }

    /**
     * Set the keyVaultProperties property: Properties provided by key vault.
     * 
     * @param keyVaultProperties the keyVaultProperties value to set.
     * @return the Encryption object itself.
     */
    public Encryption withKeyVaultProperties(KeyVaultProperties keyVaultProperties) {
        this.keyVaultProperties = keyVaultProperties;
        return this;
    }

    /**
     * Get the encryptionIdentity property: The identity to be used with service-side encryption at rest.
     * 
     * @return the encryptionIdentity value.
     */
    public EncryptionIdentity encryptionIdentity() {
        return this.encryptionIdentity;
    }

    /**
     * Set the encryptionIdentity property: The identity to be used with service-side encryption at rest.
     * 
     * @param encryptionIdentity the encryptionIdentity value to set.
     * @return the Encryption object itself.
     */
    public Encryption withEncryptionIdentity(EncryptionIdentity encryptionIdentity) {
        this.encryptionIdentity = encryptionIdentity;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (services() != null) {
            services().validate();
        }
        if (keyVaultProperties() != null) {
            keyVaultProperties().validate();
        }
        if (encryptionIdentity() != null) {
            encryptionIdentity().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("services", this.services);
        jsonWriter.writeStringField("keySource", this.keySource == null ? null : this.keySource.toString());
        jsonWriter.writeBooleanField("requireInfrastructureEncryption", this.requireInfrastructureEncryption);
        jsonWriter.writeJsonField("keyvaultproperties", this.keyVaultProperties);
        jsonWriter.writeJsonField("identity", this.encryptionIdentity);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Encryption from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of Encryption if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the Encryption.
     */
    public static Encryption fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Encryption deserializedEncryption = new Encryption();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("services".equals(fieldName)) {
                    deserializedEncryption.services = EncryptionServices.fromJson(reader);
                } else if ("keySource".equals(fieldName)) {
                    deserializedEncryption.keySource = KeySource.fromString(reader.getString());
                } else if ("requireInfrastructureEncryption".equals(fieldName)) {
                    deserializedEncryption.requireInfrastructureEncryption = reader.getNullable(JsonReader::getBoolean);
                } else if ("keyvaultproperties".equals(fieldName)) {
                    deserializedEncryption.keyVaultProperties = KeyVaultProperties.fromJson(reader);
                } else if ("identity".equals(fieldName)) {
                    deserializedEncryption.encryptionIdentity = EncryptionIdentity.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedEncryption;
        });
    }
}
