// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Encryption identity for the storage account.
 */
@Fluent
public final class EncryptionIdentity implements JsonSerializable<EncryptionIdentity> {
    /*
     * Resource identifier of the UserAssigned identity to be associated with server-side encryption on the storage
     * account.
     */
    private String encryptionUserAssignedIdentity;

    /*
     * ClientId of the multi-tenant application to be used in conjunction with the user-assigned identity for
     * cross-tenant customer-managed-keys server-side encryption on the storage account.
     */
    private String encryptionFederatedIdentityClientId;

    /**
     * Creates an instance of EncryptionIdentity class.
     */
    public EncryptionIdentity() {
    }

    /**
     * Get the encryptionUserAssignedIdentity property: Resource identifier of the UserAssigned identity to be
     * associated with server-side encryption on the storage account.
     * 
     * @return the encryptionUserAssignedIdentity value.
     */
    public String encryptionUserAssignedIdentity() {
        return this.encryptionUserAssignedIdentity;
    }

    /**
     * Set the encryptionUserAssignedIdentity property: Resource identifier of the UserAssigned identity to be
     * associated with server-side encryption on the storage account.
     * 
     * @param encryptionUserAssignedIdentity the encryptionUserAssignedIdentity value to set.
     * @return the EncryptionIdentity object itself.
     */
    public EncryptionIdentity withEncryptionUserAssignedIdentity(String encryptionUserAssignedIdentity) {
        this.encryptionUserAssignedIdentity = encryptionUserAssignedIdentity;
        return this;
    }

    /**
     * Get the encryptionFederatedIdentityClientId property: ClientId of the multi-tenant application to be used in
     * conjunction with the user-assigned identity for cross-tenant customer-managed-keys server-side encryption on the
     * storage account.
     * 
     * @return the encryptionFederatedIdentityClientId value.
     */
    public String encryptionFederatedIdentityClientId() {
        return this.encryptionFederatedIdentityClientId;
    }

    /**
     * Set the encryptionFederatedIdentityClientId property: ClientId of the multi-tenant application to be used in
     * conjunction with the user-assigned identity for cross-tenant customer-managed-keys server-side encryption on the
     * storage account.
     * 
     * @param encryptionFederatedIdentityClientId the encryptionFederatedIdentityClientId value to set.
     * @return the EncryptionIdentity object itself.
     */
    public EncryptionIdentity withEncryptionFederatedIdentityClientId(String encryptionFederatedIdentityClientId) {
        this.encryptionFederatedIdentityClientId = encryptionFederatedIdentityClientId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("userAssignedIdentity", this.encryptionUserAssignedIdentity);
        jsonWriter.writeStringField("federatedIdentityClientId", this.encryptionFederatedIdentityClientId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of EncryptionIdentity from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of EncryptionIdentity if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the EncryptionIdentity.
     */
    public static EncryptionIdentity fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            EncryptionIdentity deserializedEncryptionIdentity = new EncryptionIdentity();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("userAssignedIdentity".equals(fieldName)) {
                    deserializedEncryptionIdentity.encryptionUserAssignedIdentity = reader.getString();
                } else if ("federatedIdentityClientId".equals(fieldName)) {
                    deserializedEncryptionIdentity.encryptionFederatedIdentityClientId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedEncryptionIdentity;
        });
    }
}
