// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

/**
 * Defines values for FailoverType.
 */
public enum FailoverType {
    /**
     * Enum value Planned.
     */
    PLANNED("Planned");

    /**
     * The actual serialized value for a FailoverType instance.
     */
    private final String value;

    FailoverType(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a FailoverType instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed FailoverType object, or null if unable to parse.
     */
    public static FailoverType fromString(String value) {
        if (value == null) {
            return null;
        }
        FailoverType[] items = FailoverType.values();
        for (FailoverType item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
