// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * File service usage in storage account including account limits, file share limits and constants used in
 * recommendations and bursting formula.
 */
@Immutable
public final class FileServiceUsageProperties implements JsonSerializable<FileServiceUsageProperties> {
    /*
     * Maximum provisioned storage, IOPS, bandwidth and number of file shares limits for the storage account.
     */
    private AccountLimits storageAccountLimits;

    /*
     * Minimum and maximum provisioned storage, IOPS and bandwidth limits for a file share in the storage account.
     */
    private FileShareLimits fileShareLimits;

    /*
     * Constants used for calculating recommended provisioned IOPS and bandwidth for a file share in the storage
     * account.
     */
    private FileShareRecommendations fileShareRecommendations;

    /*
     * Constants used for calculating included burst IOPS and maximum burst credits for IOPS for a file share in the
     * storage account.
     */
    private BurstingConstants burstingConstants;

    /*
     * Usage of provisioned storage, IOPS, bandwidth and number of file shares across all live shares and soft-deleted
     * shares in the account.
     */
    private AccountUsage storageAccountUsage;

    /**
     * Creates an instance of FileServiceUsageProperties class.
     */
    public FileServiceUsageProperties() {
    }

    /**
     * Get the storageAccountLimits property: Maximum provisioned storage, IOPS, bandwidth and number of file shares
     * limits for the storage account.
     * 
     * @return the storageAccountLimits value.
     */
    public AccountLimits storageAccountLimits() {
        return this.storageAccountLimits;
    }

    /**
     * Get the fileShareLimits property: Minimum and maximum provisioned storage, IOPS and bandwidth limits for a file
     * share in the storage account.
     * 
     * @return the fileShareLimits value.
     */
    public FileShareLimits fileShareLimits() {
        return this.fileShareLimits;
    }

    /**
     * Get the fileShareRecommendations property: Constants used for calculating recommended provisioned IOPS and
     * bandwidth for a file share in the storage account.
     * 
     * @return the fileShareRecommendations value.
     */
    public FileShareRecommendations fileShareRecommendations() {
        return this.fileShareRecommendations;
    }

    /**
     * Get the burstingConstants property: Constants used for calculating included burst IOPS and maximum burst credits
     * for IOPS for a file share in the storage account.
     * 
     * @return the burstingConstants value.
     */
    public BurstingConstants burstingConstants() {
        return this.burstingConstants;
    }

    /**
     * Get the storageAccountUsage property: Usage of provisioned storage, IOPS, bandwidth and number of file shares
     * across all live shares and soft-deleted shares in the account.
     * 
     * @return the storageAccountUsage value.
     */
    public AccountUsage storageAccountUsage() {
        return this.storageAccountUsage;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (storageAccountLimits() != null) {
            storageAccountLimits().validate();
        }
        if (fileShareLimits() != null) {
            fileShareLimits().validate();
        }
        if (fileShareRecommendations() != null) {
            fileShareRecommendations().validate();
        }
        if (burstingConstants() != null) {
            burstingConstants().validate();
        }
        if (storageAccountUsage() != null) {
            storageAccountUsage().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FileServiceUsageProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FileServiceUsageProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the FileServiceUsageProperties.
     */
    public static FileServiceUsageProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FileServiceUsageProperties deserializedFileServiceUsageProperties = new FileServiceUsageProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("storageAccountLimits".equals(fieldName)) {
                    deserializedFileServiceUsageProperties.storageAccountLimits = AccountLimits.fromJson(reader);
                } else if ("fileShareLimits".equals(fieldName)) {
                    deserializedFileServiceUsageProperties.fileShareLimits = FileShareLimits.fromJson(reader);
                } else if ("fileShareRecommendations".equals(fieldName)) {
                    deserializedFileServiceUsageProperties.fileShareRecommendations
                        = FileShareRecommendations.fromJson(reader);
                } else if ("burstingConstants".equals(fieldName)) {
                    deserializedFileServiceUsageProperties.burstingConstants = BurstingConstants.fromJson(reader);
                } else if ("storageAccountUsage".equals(fieldName)) {
                    deserializedFileServiceUsageProperties.storageAccountUsage = AccountUsage.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedFileServiceUsageProperties;
        });
    }
}
