// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Minimum and maximum provisioned storage, IOPS and bandwidth limits for a file share in the storage account.
 */
@Immutable
public final class FileShareLimits implements JsonSerializable<FileShareLimits> {
    /*
     * The minimum provisioned storage quota limit in gibibytes for a file share in the storage account.
     */
    private Integer minProvisionedStorageGiB;

    /*
     * The maximum provisioned storage quota limit in gibibytes for a file share in the storage account.
     */
    private Integer maxProvisionedStorageGiB;

    /*
     * The minimum provisioned IOPS limit for a file share in the storage account.
     */
    private Integer minProvisionedIops;

    /*
     * The maximum provisioned IOPS limit for a file share in the storage account.
     */
    private Integer maxProvisionedIops;

    /*
     * The minimum provisioned bandwidth limit in mebibytes per second for a file share in the storage account.
     */
    private Integer minProvisionedBandwidthMiBPerSec;

    /*
     * The maximum provisioned bandwidth limit in mebibytes per second for a file share in the storage account.
     */
    private Integer maxProvisionedBandwidthMiBPerSec;

    /**
     * Creates an instance of FileShareLimits class.
     */
    public FileShareLimits() {
    }

    /**
     * Get the minProvisionedStorageGiB property: The minimum provisioned storage quota limit in gibibytes for a file
     * share in the storage account.
     * 
     * @return the minProvisionedStorageGiB value.
     */
    public Integer minProvisionedStorageGiB() {
        return this.minProvisionedStorageGiB;
    }

    /**
     * Get the maxProvisionedStorageGiB property: The maximum provisioned storage quota limit in gibibytes for a file
     * share in the storage account.
     * 
     * @return the maxProvisionedStorageGiB value.
     */
    public Integer maxProvisionedStorageGiB() {
        return this.maxProvisionedStorageGiB;
    }

    /**
     * Get the minProvisionedIops property: The minimum provisioned IOPS limit for a file share in the storage account.
     * 
     * @return the minProvisionedIops value.
     */
    public Integer minProvisionedIops() {
        return this.minProvisionedIops;
    }

    /**
     * Get the maxProvisionedIops property: The maximum provisioned IOPS limit for a file share in the storage account.
     * 
     * @return the maxProvisionedIops value.
     */
    public Integer maxProvisionedIops() {
        return this.maxProvisionedIops;
    }

    /**
     * Get the minProvisionedBandwidthMiBPerSec property: The minimum provisioned bandwidth limit in mebibytes per
     * second for a file share in the storage account.
     * 
     * @return the minProvisionedBandwidthMiBPerSec value.
     */
    public Integer minProvisionedBandwidthMiBPerSec() {
        return this.minProvisionedBandwidthMiBPerSec;
    }

    /**
     * Get the maxProvisionedBandwidthMiBPerSec property: The maximum provisioned bandwidth limit in mebibytes per
     * second for a file share in the storage account.
     * 
     * @return the maxProvisionedBandwidthMiBPerSec value.
     */
    public Integer maxProvisionedBandwidthMiBPerSec() {
        return this.maxProvisionedBandwidthMiBPerSec;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FileShareLimits from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FileShareLimits if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the FileShareLimits.
     */
    public static FileShareLimits fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FileShareLimits deserializedFileShareLimits = new FileShareLimits();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("minProvisionedStorageGiB".equals(fieldName)) {
                    deserializedFileShareLimits.minProvisionedStorageGiB = reader.getNullable(JsonReader::getInt);
                } else if ("maxProvisionedStorageGiB".equals(fieldName)) {
                    deserializedFileShareLimits.maxProvisionedStorageGiB = reader.getNullable(JsonReader::getInt);
                } else if ("minProvisionedIOPS".equals(fieldName)) {
                    deserializedFileShareLimits.minProvisionedIops = reader.getNullable(JsonReader::getInt);
                } else if ("maxProvisionedIOPS".equals(fieldName)) {
                    deserializedFileShareLimits.maxProvisionedIops = reader.getNullable(JsonReader::getInt);
                } else if ("minProvisionedBandwidthMiBPerSec".equals(fieldName)) {
                    deserializedFileShareLimits.minProvisionedBandwidthMiBPerSec
                        = reader.getNullable(JsonReader::getInt);
                } else if ("maxProvisionedBandwidthMiBPerSec".equals(fieldName)) {
                    deserializedFileShareLimits.maxProvisionedBandwidthMiBPerSec
                        = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedFileShareLimits;
        });
    }
}
