// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Constants used for calculating recommended provisioned IOPS and bandwidth for a file share in the storage account.
 */
@Immutable
public final class FileShareRecommendations implements JsonSerializable<FileShareRecommendations> {
    /*
     * The base IOPS in the file share provisioned IOPS recommendation formula.
     */
    private Integer baseIops;

    /*
     * The scalar for IO in the file share provisioned IOPS recommendation formula.
     */
    private Double ioScalar;

    /*
     * The base bandwidth in the file share provisioned bandwidth recommendation formula.
     */
    private Integer baseBandwidthMiBPerSec;

    /*
     * The scalar for bandwidth in the file share provisioned bandwidth recommendation formula.
     */
    private Double bandwidthScalar;

    /**
     * Creates an instance of FileShareRecommendations class.
     */
    public FileShareRecommendations() {
    }

    /**
     * Get the baseIops property: The base IOPS in the file share provisioned IOPS recommendation formula.
     * 
     * @return the baseIops value.
     */
    public Integer baseIops() {
        return this.baseIops;
    }

    /**
     * Get the ioScalar property: The scalar for IO in the file share provisioned IOPS recommendation formula.
     * 
     * @return the ioScalar value.
     */
    public Double ioScalar() {
        return this.ioScalar;
    }

    /**
     * Get the baseBandwidthMiBPerSec property: The base bandwidth in the file share provisioned bandwidth
     * recommendation formula.
     * 
     * @return the baseBandwidthMiBPerSec value.
     */
    public Integer baseBandwidthMiBPerSec() {
        return this.baseBandwidthMiBPerSec;
    }

    /**
     * Get the bandwidthScalar property: The scalar for bandwidth in the file share provisioned bandwidth recommendation
     * formula.
     * 
     * @return the bandwidthScalar value.
     */
    public Double bandwidthScalar() {
        return this.bandwidthScalar;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FileShareRecommendations from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FileShareRecommendations if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the FileShareRecommendations.
     */
    public static FileShareRecommendations fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FileShareRecommendations deserializedFileShareRecommendations = new FileShareRecommendations();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("baseIOPS".equals(fieldName)) {
                    deserializedFileShareRecommendations.baseIops = reader.getNullable(JsonReader::getInt);
                } else if ("ioScalar".equals(fieldName)) {
                    deserializedFileShareRecommendations.ioScalar = reader.getNullable(JsonReader::getDouble);
                } else if ("baseBandwidthMiBPerSec".equals(fieldName)) {
                    deserializedFileShareRecommendations.baseBandwidthMiBPerSec
                        = reader.getNullable(JsonReader::getInt);
                } else if ("bandwidthScalar".equals(fieldName)) {
                    deserializedFileShareRecommendations.bandwidthScalar = reader.getNullable(JsonReader::getDouble);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedFileShareRecommendations;
        });
    }
}
