// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.fluent.models.ListContainerItemInner;
import java.io.IOException;
import java.util.List;

/**
 * Response schema. Contains list of blobs returned, and if paging is requested or required, a URL to next page of
 * containers.
 */
@Immutable
public final class ListContainerItems implements JsonSerializable<ListContainerItems> {
    /*
     * List of blobs containers returned.
     */
    private List<ListContainerItemInner> value;

    /*
     * Request URL that can be used to query next page of containers. Returned when total number of requested containers
     * exceed maximum page size.
     */
    private String nextLink;

    /**
     * Creates an instance of ListContainerItems class.
     */
    public ListContainerItems() {
    }

    /**
     * Get the value property: List of blobs containers returned.
     * 
     * @return the value value.
     */
    public List<ListContainerItemInner> value() {
        return this.value;
    }

    /**
     * Get the nextLink property: Request URL that can be used to query next page of containers. Returned when total
     * number of requested containers exceed maximum page size.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ListContainerItems from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ListContainerItems if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ListContainerItems.
     */
    public static ListContainerItems fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ListContainerItems deserializedListContainerItems = new ListContainerItems();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<ListContainerItemInner> value
                        = reader.readArray(reader1 -> ListContainerItemInner.fromJson(reader1));
                    deserializedListContainerItems.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedListContainerItems.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedListContainerItems;
        });
    }
}
