// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.fluent.models.TableInner;
import java.io.IOException;
import java.util.List;

/**
 * Response schema. Contains list of tables returned.
 */
@Immutable
public final class ListTableResource implements JsonSerializable<ListTableResource> {
    /*
     * List of tables returned.
     */
    private List<TableInner> value;

    /*
     * Request URL that can be used to query next page of tables
     */
    private String nextLink;

    /**
     * Creates an instance of ListTableResource class.
     */
    public ListTableResource() {
    }

    /**
     * Get the value property: List of tables returned.
     * 
     * @return the value value.
     */
    public List<TableInner> value() {
        return this.value;
    }

    /**
     * Get the nextLink property: Request URL that can be used to query next page of tables.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ListTableResource from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ListTableResource if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ListTableResource.
     */
    public static ListTableResource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ListTableResource deserializedListTableResource = new ListTableResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<TableInner> value = reader.readArray(reader1 -> TableInner.fromJson(reader1));
                    deserializedListTableResource.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedListTableResource.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedListTableResource;
        });
    }
}
