// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The Storage Account ManagementPolicies Rules. See more details in:
 * https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.
 */
@Fluent
public final class ManagementPolicySchema implements JsonSerializable<ManagementPolicySchema> {
    /*
     * The Storage Account ManagementPolicies Rules. See more details in:
     * https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.
     */
    private List<ManagementPolicyRule> rules;

    /**
     * Creates an instance of ManagementPolicySchema class.
     */
    public ManagementPolicySchema() {
    }

    /**
     * Get the rules property: The Storage Account ManagementPolicies Rules. See more details in:
     * https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.
     * 
     * @return the rules value.
     */
    public List<ManagementPolicyRule> rules() {
        return this.rules;
    }

    /**
     * Set the rules property: The Storage Account ManagementPolicies Rules. See more details in:
     * https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.
     * 
     * @param rules the rules value to set.
     * @return the ManagementPolicySchema object itself.
     */
    public ManagementPolicySchema withRules(List<ManagementPolicyRule> rules) {
        this.rules = rules;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (rules() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property rules in model ManagementPolicySchema"));
        } else {
            rules().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ManagementPolicySchema.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("rules", this.rules, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagementPolicySchema from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagementPolicySchema if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ManagementPolicySchema.
     */
    public static ManagementPolicySchema fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagementPolicySchema deserializedManagementPolicySchema = new ManagementPolicySchema();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("rules".equals(fieldName)) {
                    List<ManagementPolicyRule> rules
                        = reader.readArray(reader1 -> ManagementPolicyRule.fromJson(reader1));
                    deserializedManagementPolicySchema.rules = rules;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagementPolicySchema;
        });
    }
}
