// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * SasPolicy assigned to the storage account.
 */
@Fluent
public final class SasPolicy implements JsonSerializable<SasPolicy> {
    /*
     * The SAS expiration period, DD.HH:MM:SS.
     */
    private String sasExpirationPeriod;

    /*
     * The SAS Expiration Action defines the action to be performed when sasPolicy.sasExpirationPeriod is violated. The
     * 'Log' action can be used for audit purposes and the 'Block' action can be used to block and deny the usage of SAS
     * tokens that do not adhere to the sas policy expiration period.
     */
    private ExpirationAction expirationAction;

    /**
     * Creates an instance of SasPolicy class.
     */
    public SasPolicy() {
    }

    /**
     * Get the sasExpirationPeriod property: The SAS expiration period, DD.HH:MM:SS.
     * 
     * @return the sasExpirationPeriod value.
     */
    public String sasExpirationPeriod() {
        return this.sasExpirationPeriod;
    }

    /**
     * Set the sasExpirationPeriod property: The SAS expiration period, DD.HH:MM:SS.
     * 
     * @param sasExpirationPeriod the sasExpirationPeriod value to set.
     * @return the SasPolicy object itself.
     */
    public SasPolicy withSasExpirationPeriod(String sasExpirationPeriod) {
        this.sasExpirationPeriod = sasExpirationPeriod;
        return this;
    }

    /**
     * Get the expirationAction property: The SAS Expiration Action defines the action to be performed when
     * sasPolicy.sasExpirationPeriod is violated. The 'Log' action can be used for audit purposes and the 'Block' action
     * can be used to block and deny the usage of SAS tokens that do not adhere to the sas policy expiration period.
     * 
     * @return the expirationAction value.
     */
    public ExpirationAction expirationAction() {
        return this.expirationAction;
    }

    /**
     * Set the expirationAction property: The SAS Expiration Action defines the action to be performed when
     * sasPolicy.sasExpirationPeriod is violated. The 'Log' action can be used for audit purposes and the 'Block' action
     * can be used to block and deny the usage of SAS tokens that do not adhere to the sas policy expiration period.
     * 
     * @param expirationAction the expirationAction value to set.
     * @return the SasPolicy object itself.
     */
    public SasPolicy withExpirationAction(ExpirationAction expirationAction) {
        this.expirationAction = expirationAction;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (sasExpirationPeriod() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property sasExpirationPeriod in model SasPolicy"));
        }
        if (expirationAction() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property expirationAction in model SasPolicy"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(SasPolicy.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("sasExpirationPeriod", this.sasExpirationPeriod);
        jsonWriter.writeStringField("expirationAction",
            this.expirationAction == null ? null : this.expirationAction.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SasPolicy from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SasPolicy if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the SasPolicy.
     */
    public static SasPolicy fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SasPolicy deserializedSasPolicy = new SasPolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("sasExpirationPeriod".equals(fieldName)) {
                    deserializedSasPolicy.sasExpirationPeriod = reader.getString();
                } else if ("expirationAction".equals(fieldName)) {
                    deserializedSasPolicy.expirationAction = ExpirationAction.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSasPolicy;
        });
    }
}
